Extension { #name : 'BtreePlusLeafKeyValueRootObjectNode' }

{ #category : 'Constants' }
BtreePlusLeafKeyValueRootObjectNode class >> entrySize [
  "Returns the size of an entry with no encryption."

  "in-lined on instance-side for performance"

  ^ 3

]

{ #category : 'Constants' }
BtreePlusLeafKeyValueRootObjectNode class >> maxNumberOfElements [
  "Returns the number of entries that are allowed in an interior node."

  ^ 676

]

{ #category : 'Updating' }
BtreePlusLeafKeyValueRootObjectNode >> _insertKey: aKey value: aValue root: rootObject atIndex: insertionIndex [
  "Insert the key/value pair in the receiver.  The sender of this message must
verify that the entry will fit in the receiver and provide the insertion
index."

  | endIndex entrySize |
  entrySize := self entrySize.
  endIndex := numElements * entrySize.
  self _insertAt: insertionIndex
       value: aValue value: aKey value: rootObject
       numToMoveDown: endIndex - insertionIndex + 1.

  "no prefix encoding."

  numElements := numElements + 1


]

{ #category : 'Updating' }
BtreePlusLeafKeyValueRootObjectNode >> _insertKey: aKey value: aValue root: rootObject atIndex: insertionIndex selectiveAbortSet: ignored [
"Compat with BtreePlustInteriorNode api ... inserts do not require selective abort logic"

  self _insertKey: aKey value: aValue root: rootObject atIndex: insertionIndex


]

{ #category : 'Updating' }
BtreePlusLeafKeyValueRootObjectNode >> at: aKey put: aValue root: rootObject [
  "Adds the key/value/root pair to the node.  If the node is full, performs a 'split'
 on the parent.  Returns the new sibling if a split is performed, otherwise
 returns the receiver."

  | index |
  " determine if a split is needed "
  numElements == self maxNumberOfElements
    ifTrue: [ " performs the split and returns the new sibling "
      ^ self _splitUsingKey: aKey value: aValue root: rootObject ]
    ifFalse: [ " entry will fit in leaf node "
      numElements == 0
        ifTrue: [ index := 1 ]
        ifFalse: [ index := self binarySearchCoveringKey: aKey value: aValue root: rootObject ].
      self
        _insertKey: aKey
        value: aValue
        root: rootObject
        atIndex: index ]

]

{ #category : 'Updating' }
BtreePlusLeafKeyValueRootObjectNode >> at: aKey put: aValue root: rootObject selectiveAbortSet: selectiveAbortSetOrNil [
  "Adds the key/value/root pair to the node.  If the node is full, performs a 'split'
 on the parent.  Returns the new sibling if a split is performed, otherwise
 returns the receiver."

  | index |
  " determine if a split is needed "
  self _selectiveAbort: self ifNotIn: selectiveAbortSetOrNil.
  self rootNode _addBtreePlusNodeToRcReadSet: self.
  numElements == self maxNumberOfElements
    ifTrue: [ " performs the split and returns the new sibling "
      ^ self _splitUsingKey: aKey value: aValue root: rootObject selectiveAbortSet: selectiveAbortSetOrNil ]
    ifFalse: [ " entry will fit in leaf node "
      numElements == 0
        ifTrue: [ index := 1 ]
        ifFalse: [ index := self binarySearchCoveringKey: aKey value: aValue root: rootObject ].
      self
        _insertKey: aKey
        value: aValue
        root: rootObject
        atIndex: index ]

]

{ #category : 'Comparison Operators' }
BtreePlusLeafKeyValueRootObjectNode >> compareValueOop: aValue greaterThanEntryValueOopAt: keyIndex root: aRootObject [
  "Perform a > comparison between the oop of aValue and oop of the entry whose value is
   at the given index. If the value oops are equal, compare the oop of aRootObject and the
   oop of the root object at the given index."

  | keyIndexOffset entryValue |
  keyIndexOffset := self keyIndexOffset.
  entryValue := self at: keyIndex - keyIndexOffset.
  "aValue asOop = entryValue asOop"
  aValue == entryValue
    ifTrue: [ ^ aRootObject asOop > (self at: keyIndex - keyIndexOffset + self rootIndexOffset) asOop ].
  ^ aValue asOop > entryValue asOop

]

{ #category : 'Comparison Operators' }
BtreePlusLeafKeyValueRootObjectNode >> compareValueOop: aValue lessThanOrEqualToEntryValueOopAt: keyIndex root: aRootObject [
  "Perform a <= comparison between the oop of aValue and oop of the entry whose value is
   at the given index. If the value oops are equal, compare the oop of aRootObject and the
   oop of the root object at the given index."

  | keyIndexOffset entryValue |
  keyIndexOffset := self keyIndexOffset.
  entryValue := self at: keyIndex - keyIndexOffset.
  "aValue asOop = entryValue asOop"
  aValue == entryValue
    ifTrue: [ ^ aRootObject asOop <= (self at: keyIndex - keyIndexOffset + self rootIndexOffset) asOop ].
  ^ aValue asOop < entryValue asOop

]

{ #category : 'Constants' }
BtreePlusLeafKeyValueRootObjectNode >> entrySize [
  "Returns the size of an entry."

  "in-line of `self class entrySize` for performance"

  ^ 3

]

{ #category : 'Constants' }
BtreePlusLeafKeyValueRootObjectNode >> parentNodeClass [
  "Returns the class of node to be created as the parent when a split occurs."

  ^ BtreePlusInteriorKeyValueRootObjectNode

]
