Extension { #name : 'BtreePlusRootObjectMap' }

{ #category : 'instance creation' }
BtreePlusRootObjectMap class >> new [
  ^ self basicNew
    initialize;
    yourself

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> cumulativeFactor [

   ^cumulativeFactor

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> cumulativeFactor: anObject [

   cumulativeFactor := anObject

]

{ #category : 'initialization' }
BtreePlusRootObjectMap >> initialize [
  roots := BtreePlusTraversalMapDictionary new.
  cumulativeFactor := 0.
  traversalMap := BtreePlusTraversalMapDictionary new.

]

{ #category : 'copying' }
BtreePlusRootObjectMap >> mergeFromCopy: aRootObjectMap [
  | newBag |
  aRootObjectMap roots keysAndValuesDo: [ :rootObj :rootIndexBag |
    (self roots at: rootObj otherwise: nil)
      ifNotNil: [ :oldBag |
        newBag := rootIndexBag _union: oldBag ]
      ifNil: [
        newBag := rootIndexBag ].
    self roots at: rootObj put: newBag ].
  aRootObjectMap traversalMap keysAndValuesDo: [ :obj :indexBag |
    (traversalMap at: obj otherwise: nil)
      ifNotNil: [ :oldBag |
        newBag := indexBag _union: oldBag ]
      ifNil: [
        newBag := indexBag ].
    self traversalMap at: obj put: newBag ]

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> pivotObject [

   ^pivotObject

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> pivotObject: anObject [

   pivotObject := anObject

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> pivotPathTerm [

   ^pivotPathTerm

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> pivotPathTerm: anObject [

   pivotPathTerm := anObject

]

{ #category : 'copying' }
BtreePlusRootObjectMap >> postCopy [
  roots := BtreePlusTraversalMapDictionary new.
  traversalMap := BtreePlusTraversalMapDictionary new

]

{ #category : 'resolving' }
BtreePlusRootObjectMap >> resolveTraversalRootObjectsFor: anObject [
  ^ self
    resolveTraversalRootObjectsFor: anObject
    level: self pivotPathTerm offset
    into: IdentityBag new
    visited: IdentitySet new.

]

{ #category : 'resolving' }
BtreePlusRootObjectMap >> resolveTraversalRootObjectsFor: anObject level: level into: defaultRoots visited: visited [

  | objs bag currentLevel |
  level = 0
    ifTrue: [ ^ defaultRoots ].
  bag := self traversalMap at: anObject ifAbsent: [ ^ self roots at: anObject ifAbsent: [defaultRoots]].
  objs := IdentityBag new.
  currentLevel := level.
  bag
    do: [ :obj |
      (visited includes: obj)
        ifFalse: [
          obj class isNsc
            ifTrue: [ currentLevel := level + 1 ].
          visited add: obj.
          objs := objs
            _union:
              (self
                resolveTraversalRootObjectsFor: obj
                level: currentLevel - 1
                into: bag
                visited: visited) ] ].
  ^ objs

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> roots [

   ^roots

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> roots: anObject [

   roots := anObject

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> traversalMap [

   ^traversalMap

]

{ #category : 'accessing' }
BtreePlusRootObjectMap >> traversalMap: anObject [

   traversalMap := anObject

]
