Extension { #name : 'BtreePlusTraversalMapDictionary' }

{ #category : 'Accessing' }
BtreePlusTraversalMapDictionary >> at: aKey [

aKey ifNil: [ ^ super at: self].
^ super at: aKey

]

{ #category : 'Accessing' }
BtreePlusTraversalMapDictionary >> at: aKey ifAbsent: aBlock [

aKey ifNil: [ ^ super at: self ifAbsent: aBlock ].
^ super at: aKey ifAbsent: aBlock

]

{ #category : 'Accessing' }
BtreePlusTraversalMapDictionary >> at: aKey ifAbsentPut: aBlock [

aKey ifNil: [ ^ super at: self ifAbsentPut: aBlock ].
^ super at: aKey ifAbsentPut: aBlock

]

{ #category : 'Accessing' }
BtreePlusTraversalMapDictionary >> at: aKey otherwise: defaultValue [

aKey ifNil: [ ^ super at: self otherwise: defaultValue ].
^ super at: aKey otherwise: defaultValue

]

{ #category : 'Updating' }
BtreePlusTraversalMapDictionary >> at: aKey put: aValue [

aKey ifNil: [ ^ super at: self put: aValue ].
^ super at: aKey put: aValue

]

{ #category : 'Enumerating' }
BtreePlusTraversalMapDictionary >> keysAndValuesDo: aBlock [

"Evaluates aBlock with each of the receiver's key/value pairs as the
 arguments.  The argument aBlock must be a two-argument block.  The
 first argument is the key and the second argument is the value of
 each key/value pair."

| aKey collisionBkt |

1 to: tableSize * 2 by: 2 do: [ :tableIndex |
  (aKey := self _at: tableIndex) ifNil: [
    (collisionBkt := self _at: (tableIndex + 1)) ifNotNil: [
      1 to: collisionBkt _basicSize by: 2 do: [ :j |
        (aKey := collisionBkt _at: j) ifNotNil: [
          aKey == self ifTrue: [ aKey := nil ].
          aBlock value: aKey value: (collisionBkt _at: j + 1).
	].
      ].
    ].
  ] ifNotNil: [
    aKey == self ifTrue: [ aKey := nil ].
    aBlock value: aKey value: (self _at: tableIndex + 1).
  ].
].

]

{ #category : 'Removing' }
BtreePlusTraversalMapDictionary >> removeKey: aKey ifAbsent: aBlock [
  aKey ifNil: [ ^ super removeKey: self ifAbsent: aBlock ].
  ^ super removeKey: aKey ifAbsent: aBlock

]
