Extension { #name : 'CFunction' }

{ #category : 'Instance Creation' }
CFunction class >> _basicNew [

  "creates an instance registered with VM for finalization of cData"
  <primitive: 674>
  ^self _primitiveFailed: #_basicNew

]

{ #category : 'Instance Creation' }
CFunction class >> basicNew [
 "disallowed"
  self shouldNotImplement: #basicNew

]

{ #category : 'Instance Creation' }
CFunction class >> name: aName result: resType args: argumentTypes [
  "aName is the C function name of the new Callout .

  resType, argumentTypes, varArgsAfter are per the comments in
    CCallout>>name:result:args: . 
  See comments in CCallout>>callWith: for details on calling with varArgs."

  | res |
  (res := self _basicNew)
     _name: aName result: resType args: argumentTypes varArgsAfter: -1 .
  res immediateInvariant .
  ^ res

]

{ #category : 'Instance Creation' }
CFunction class >> name: aName result: resType args: argumentTypes
varArgsAfter: varArgsAfter [
  "aName is the C function name of the new Callin .

  resType, argumentTypes, varArgsAfter are per the comments in
    CCallout>>library:name:result:args:varArgsAfter: . 
  See comments in CCallout>>callWith: for details on calling with varArgs."

  | res |
  (res := self _basicNew)
      _name: aName result: resType
                        args: argumentTypes varArgsAfter: varArgsAfter .
  res immediateInvariant .
  ^ res

]

{ #category : 'Instance Creation' }
CFunction class >> new [
 "disallowed"
  self shouldNotImplement: #new

]

{ #category : 'Private' }
CFunction >> _name: aName result: resType args: argumentTypes varArgsAfter: varArgsAfter [

 "If C varargs allowed, varArgsAfter must be >=0   and
    <  argumentTypes size   , and must also be <=4  ,
  else varArgsAfter==-1 to denote no varargs .
  See comments in CCallout>>callWith: for details on calling with varArgs."

 | rType numAtypes ctyps |
 (aName isKindOfClass: String) ifFalse:[
   ArgumentTypeError new name: 'aName' expectedClass: String actualArg: aName ; signal .
   ^ nil
 ].
 aName size > 1023 ifTrue:[  "must agree with code in VM prim 710"
   ArgumentError new name: 'fName' ; signal: 'CFunction name exceeds 1023 chars' .
   ^ nil
 ].
 fName := aName .

 (rType := ResTypesDict at: resType otherwise: nil ) ifNil:[
   ArgumentError new name: 'resType' ; signal: 'not a valid CFunction result type'  .
   ^ nil
 ].
 resultType := resType .
 numAtypes := argumentTypes size .
 ctyps := ByteArray new: numAtypes + 1 .
 ctyps at: 1 put: rType .  "for C type of result"
 argumentTypes ifNotNil:[
   numAtypes > CFUNC_max_params ifTrue:[
     ArgumentError new name: 'argumentTypes' ;
       signal: 'CFunction number of args must be <= ', CFUNC_max_params asString  .
     ^ nil
   ].
   1 to: numAtypes do:[:j | | aSym typ |
     aSym :=  argumentTypes at: j .
     (typ := ArgTypesDict at: aSym otherwise: nil ) ifNil:[
       ((aSym isKindOfClass: CCallin) and:[ self isKindOfClass: CCallout]) ifTrue:[
         argumentTypes at: j put:( aSym _copyForCFunction ) .
         typ := ArgTypesDict at: #ffiCallback .
       ] ifFalse:[
         ArgumentError signal: aSym printString , ' is not a valid CFunction arg type' .
         ^ nil
       ].
     ].
     ctyps at: j + 1 put: typ .  "type of an arg"
   ].
 ].
 argTypes := argumentTypes .
 varArgsAfter >= 0 ifTrue:[
   varArgsAfter <= numAtypes ifTrue:[
      argCounts := varArgsAfter bitOr:  ArgCounts_varArgsMask .
      argTypesDict := ArgTypesDict .
   ] ifFalse:[
     ArgumentError new name:'varArgsAfter' ;
	signal:'varArgsAfter must be -1, or <= number of types'.
   ]
 ] ifFalse:[
   argCounts := numAtypes .
   varArgsAfter == -1 ifFalse:[
     ArgumentError new name:'varArgsAfter';
	signal:'varArgsAfter must be -1, or <= number of types'.
   ].
 ].
 ctyps immediateInvariant.
 cTypes := ctyps .

]

{ #category : 'Formatting' }
CFunction >> asString [
  | res fn |
  res := super asString .
  (fn := fName) ifNotNil:[  res add: $  ; add: fn ].
  ^ res

]

{ #category : 'Formatting' }
CFunction >> numFixedArgs [
  ^ argCounts bitAnd: ArgCounts_fixedMask

]

{ #category : 'Formatting' }
CFunction >> numParameterTypes [
  ^ argTypes size

]

{ #category : 'Formatting' }
CFunction >> signatureString [
  | res fn types nTypes nFixed varAllowed |
  (res := resultType asString) .
  (fn := fName) ifNotNil:[
     types := argTypes .
     nTypes := types size .
     nFixed := self numFixedArgs .
     varAllowed := self varArgsAllowed .
     res add: $  ; add: fn ; add: $(  .
     1 to: nFixed do:[:n | | aType |
       n > 1 ifTrue:[ res add: ', ' ].
       aType := types at: n .
       aType _isSymbol ifTrue:[ res add: aType ]
                      ifFalse:[ res add:( aType callinName ); add: '()' ].
     ].
     varAllowed ifTrue:[
       res add:', (VarArgs:) '.
       nFixed + 1 to: nTypes do:[:m | | aType |
         m > (nFixed + 1) ifTrue:[ res add: ', ' ].
         aType := types at: m .
         aType _isSymbol ifTrue:[ res add: aType ]
                      ifFalse:[ res add:( aType callinName ); add: '()' ].
       ].
     ].
     res add: $)  .
  ].
  ^ res

]

{ #category : 'Formatting' }
CFunction >> varArgsAllowed [
  ^ (argCounts bitAnd: ArgCounts_varArgsMask) ~~ 0

]

{ #category : 'Accessing' }
CFunction >> name [
 ^ fName
]

{ #category : 'Accessing' }
CFunction >> coerceNameToSymbol [
   fName := fName asSymbol
]

{ #category : 'Private' }
CFunction >> instVarAt: anIndex put: aValue [
  "Allow activate from a PassiveObject"
  ^ self _unsafeAt: anIndex put: aValue

]
