Extension { #name : 'CLibrary' }

{ #category : 'Private' }
CLibrary class >> _basicNew [

  "creates an instance registered with VM for finalization of cData"
  <primitive: 674>
  ^self _primitiveFailed: #_basicNew

]

{ #category : 'Private' }
CLibrary class >> _prim: opcode arg: anArg arg: argTwo [
  "opcode==4  process dlsym() or dlvsym "

<primitive: 709>
anArg _validateClass: String .
argTwo ifNotNil:[
  argTwo _validateClass: String
].
self _primitiveFailed: #_prim:arg:arg: args: { opcode . anArg . argTwo }

]

{ #category : 'Private' }
CLibrary class >> basicNew [

 "disallowed"
  self shouldNotImplement: #basicNew

]

{ #category : 'Accessing' }
CLibrary class >> hasCSymbol: aString [

"return true if dlsym() finds specified name in any loaded library
 in the current process."

^ self _prim: 4 arg: aString arg: nil 

]

{ #category : 'Accessing' }
CLibrary class >> hasCSymbol: aString version: versionString [

"return true if dlvsym() finds specified name in any loaded library
 in the current process.  versionString should be non-nil . "
 
^ self _prim: 4 arg: aString arg: versionString

]

{ #category : 'Instance creation' }
CLibrary class >> named: libraryName [

  "if libraryName does not include a  '.'  character, then the OS dependent
   suffix such as  '.so'   will be appended prior to attempting to load
   the library"

  ^ self _basicNew _initialize: libraryName

]

{ #category : 'Private' }
CLibrary class >> new [
 "disallowed"
  self shouldNotImplement: #new

]

{ #category : 'Private' }
CLibrary >> _initialize: aName [
  (aName isKindOfClass: String) ifFalse:[
    aName _error: #rtErrBadArgKind args: { String }.
  ].
  aName size > 2047 ifTrue:[  "must agree with loadCLibrary in VM"
    aName _error: #errArgTooLarge args:{ 2047 } .
  ].
  name := aName

]

{ #category : 'Accessing' }
CLibrary >> _libNameForSymbol: aString [
  "Call dlsym() for aString use receiver's handle from dlopen().
   If dlsym() returns non-NULL
     if dladdr() supported by the OS
       return a String containing dladdr(dlsym(aString))->dli_fname
     else
       return true .

Returns nil if shared library represented by receiver cannot
   be loaded, dlsym() fails to find aString, or dladdr() fails.
  "
  ^ self _prim: 3 arg: aString arg: nil 

]

{ #category : 'Accessing' }
CLibrary >> _libNameForSymbol: aString version: versionString [
  "Call dlvsym() for aString use receiver's handle from dlopen().
   If dlvsym() returns non-NULL
     if dladdr() supported by the OS
       return a String containing dladdr(dlsym(aString))->dli_fname
     else
       return true .

  versionString should be non-nil .
   
Returns nil if shared library represented by receiver cannot
   be loaded, dlsym() fails to find aString, or dladdr() fails.
  "
  ^ self _prim: 3 arg: aString arg: versionString
 

]

{ #category : 'Private' }
CLibrary >> _prim: opcode arg: anArg arg: argTwo [

" opcode==0  isLoaded,  anArg not used .
  opcode==1  load  , anArg is Boolean rtldNow
  opcode==2  expandedName  , anArg not used .
  opcode==3  dlsym(). anArg is a String. , argTwo nil. If receiver not loaded,
               does  (self _prim:1 arg:false) before calling dlsym()
  opcode==3  dlvsym(). anArg is a String, argTwo aString. If receiver not loaded,
               does  (self _prim:1 arg:false) before calling dlsym()
"

<primitive: 709>

opcode == 3 ifTrue:[ 
  anArg _validateClass: String .
  argTwo ifNotNil:[ argTwo _validateClass: String ].
].
opcode == 1 ifTrue:[ anArg _validateClass: Boolean ].
self _primitiveFailed: #_prim:arg:arg: args: { opcode . anArg }

]

{ #category : 'Accessing' }
CLibrary >> expandedName [

 "If dlopen() has been successfully called for the in-memory copy
  of the receiver, then return the expanded name as it was passed to dlopen,
  otherwise return the name after expanding environment variables and
  symbolic links as described in CLibary>>load. "

 name == nil ifTrue:[ self error:'nil name'].
 ^ self _prim: 2 arg: nil arg: nil

]

{ #category : 'Accessing' }
CLibrary >> hasCSymbol: aString [

"Return true if dlsym() finds specified name in the shared library
 represented by receiver. dladdr() used if available to qualify
 the result of dlsym() to within receiver's shared library.

 dladdr() not implemented on AIX, so this method will return
 true if the specified name exists in any library loaded thus
 far into the process."

| dladdrLibNam expName |
dladdrLibNam := self _libNameForSymbol: aString .
self isLoaded ifFalse:[ ^ false ].
dladdrLibNam ifNil:[ ^ false ].
dladdrLibNam == true ifTrue:[
  "found by dlsym() and dladdr() not supported by OS"
  ^ true
].
expName := self expandedName .
"ignore version numbers on .so  which is target of a symlink"
(dladdrLibNam at: 1 equals: expName ) ifTrue:[ ^ true ].
(expName at: ((expName size - 2) max: 1) equals:'.so') ifTrue:[
  "solaris or linux"
  ^ (dladdrLibNam findString: expName startingAt: 1) >= 1 .
].
(expName at: ((expName size - 5) max: 1) equals:'.dylib') ifTrue:[ | k |
   "mac"
  k := expName indexOf: $. startingAt: 1 .
  k >= 1 ifTrue:[ | prefix |
    prefix := expName copyFrom: 1 to: k .
    ^ (dladdrLibNam findString: prefix startingAt: 1) >= 1
  ].
].
^ false

]

{ #category : 'Accessing' }
CLibrary >> isLoaded [

"Return true if shared library described by receiver has been loaded
 since the receiver was created or faulted into memory,
 false otherwise."

^ self _prim: 0 arg: nil arg: nil .

]

{ #category : 'Accessing' }
CLibrary >> lastError [
 "Return the String returned by dlerror() from the last failed dlopen()
  since this object was created or faulted into memory ."

  self isLoaded . "ensure current C state"
  ^ lastError

]

{ #category : 'Loading' }
CLibrary >> load [
"  Load the shared library described by receiver if not already loaded.
   Before calling dlopen(), any environment variables in the name
   (beginning with $$ and limited by $/ ) are expanded using the
   current environment of the session's gem or topaz -l process,
   and symbolic links are followed.  The name must not exceed 2046
   characters and the expanded form must not exceed 8190 characters.
   The flags to dlopen include RTLD_LAZY.
   On AIX, lazy bind is not implemented (RTLD_LAZY has RTLD_NOW semantics).
   See CLibrary(C)>>comment for details of flags passed to dlopen().

   Returns true if successful, or a String describing the error from dlopen().
"

 ^ self _prim: 1 arg: false arg: nil 

]

{ #category : 'Loading' }
CLibrary >> loadResolveAll [

  "Like  Clibrary>>load, except flags to dlopen include RTLD_NOW."

 ^ self _prim: 1 arg: true arg: nil 

]

{ #category : 'Accessing' }
CLibrary >> name [

^ name

]
