Extension { #name : 'CharacterCollection' }

{ #category : 'Indexing Support' }
CharacterCollection class >> _idxCanOptimizeComparison [
  "Answer true if it is possible to optimize index-related comparisons by replacing
   _idxForCompare* calles with a primitive comparison call instead.

     _idxForCompareEqualTo:              #=
     _idxForCompareGreaterThan:          #>
     _idxForCompareGreaterThanOrEqualTo: #>=
     _idxForCompareLessThan:             #<
     _idxForCompareLessThanOrEqualTo:    #<=
     _idxForCompareNotEqualTo:           #~=
   "

  "In order to optimize Numeric comparisons, NANs (#_isNaN is true) must be excluded
   from indexed collection"


  "In order to optimize CharacterCollection comparisons, elements of the indexed collections
   must be all Symbols or all Unicode Strings."

  ^ true

]

{ #category : 'New Indexing Comparison' }
CharacterCollection >> _idxForCompareEqualToCharacterCollection: arg [
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ self _idxPrimCompareEqualTo: arg

]

{ #category : 'New Indexing Comparison - for Compare' }
CharacterCollection >> _idxForCompareEqualToUnicode: aUnicodeString collator: anIcuCollator [
"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ (aUnicodeString compareTo: self collator: anIcuCollator useMinSize: 900)
    == 0

]

{ #category : 'New Indexing Comparison - for Compare' }
CharacterCollection >> _idxForCompareGreaterThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any >= comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) >= 0

]

{ #category : 'New Indexing Comparison - for Compare' }
CharacterCollection >> _idxForCompareGreaterThanUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThan:collator:. Note that aUnicodeString should be the receiver in any > comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == 1

]

{ #category : 'New Indexing Comparison - for Compare' }
CharacterCollection >> _idxForCompareLessThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any <= comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) <= 0

]

{ #category : 'New Indexing Comparison - for Compare' }
CharacterCollection >> _idxForCompareLessThanUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThan:collator:. Note that aUnicodeString should be the receiver in any < comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == -1

]

{ #category : 'New Indexing Comparison - for Sort' }
CharacterCollection >> _idxForSortEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortEqualTo:collator:."

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == 0

]

{ #category : 'New Indexing Comparison' }
CharacterCollection >> _idxForSortEqualToSymbol: aSymbol [
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ self _idxPrimCompareEqualTo: aSymbol asString

]

{ #category : 'New Indexing Comparison - for Sort' }
CharacterCollection >> _idxForSortGreaterThanCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThan:collator:. Note that aCharacterCollection should be the receiver in any > comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == 1

]

{ #category : 'New Indexing Comparison - for Sort' }
CharacterCollection >> _idxForSortGreaterThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any >= comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) >= 0

]

{ #category : 'New Indexing Comparison - for Sort' }
CharacterCollection >> _idxForSortLessThanCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThan:collator:. Note that aCharacterCollection should be the receiver in any < comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == -1

]

{ #category : 'New Indexing Comparison - for Sort' }
CharacterCollection >> _idxForSortLessThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any <= comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) <= 0

]

{ #category : 'Indexing Support' }
CharacterCollection >> _idxOptimizedCompareWithClass: aClass [
  "Returns true if the receiver may be inserted into a BtreePlusNode whose
   #lastElementClass is <aClass> and whose comparisons are optimized."

  "Sent when index option optimizeComparison is true and aClass responds true to #_idxCanOptimizeComparison"

  "if aClass is Symbol, DoubleByteSymbol, or QuadByteSymbol the receiver must be a symbol.
   Otherwise the receiver must not be a Symbol. "

  self class == aClass ifTrue: [ ^ true ].
  (self _idxBasicCanCompareWithClass: aClass)
    ifFalse: [
        "If using Unicode compares, then *String and Unicode* instances may be compared.
         If not using Unicode compares then *String and Unicode* instances may not be compared."
      ^ false ].
  ({Symbol. DoubleByteSymbol. QuadByteSymbol} includes: aClass)
    ifTrue: [ ^ self _isSymbol ].
  ^self _isSymbol not

]

{ #category : 'Index Query Support' }
CharacterCollection >> asCachedQuery [
  ^ GsQuery
    fromString: self
    options: GsQueryOptions default + GsQueryOptions cacheQueryResult

]

{ #category : 'Index Query Support' }
CharacterCollection >> asCachedQueryOn: anNsc [
  ^ GsQuery
    fromString: self
    on: anNsc
    options: GsQueryOptions default + GsQueryOptions cacheQueryResult

]

{ #category : 'PetitParser-Core-Converting' }
CharacterCollection >> asParser [
	"Answer a parser that accepts the receiving string."

	^ PPLiteralSequenceParser on: self

]

{ #category : 'Index Query Support' }
CharacterCollection >> asQuery [
  ^ GsQuery fromString: self

]

{ #category : 'Index Query Support' }
CharacterCollection >> asQueryOn: anNsc [
  ^ GsQuery fromString: self on: anNsc

]

{ #category : 'Non-Printable Characters' }
CharacterCollection >> tab [
"Appends a tab to the receiver and returns the receiver."

  self addCodePoint: 9

]
