Extension { #name : 'CollectionBasedPathEvaluator' }

{ #category : 'Accessing' }
CollectionBasedPathEvaluator >> _pathTermsRequired [
  pathTermsRequired ifNil: [ pathTermsRequired := true ].
  ^ pathTermsRequired

]

{ #category : 'Accessing' }
CollectionBasedPathEvaluator >> _pathTermsRequired: aBoolOrNil [
  pathTermsRequired := aBoolOrNil

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> _traverse: anObject cachedOffsets: offsets cachedClasses: classes incomplete: incompletePathTraversal [
  "This method assumes that the index is not over a set-valued instance variable."

  self shouldNotImplement: #'_traverse:cachedOffsets:cachedClasses:incomplete:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> _traverseObject: anObject [
  "Traverse the sub-objects of the given object using the path names of the
 receiver.  This method assumes that the index is not over a set-valued
 instance variable.  For that kind of index, use the traverse:startingAt:into:
 method.  If a nil value is reached before the end of the path, returns the
 incompletePathTraversalObject."

  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'_traverseObject:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> _traverseObject: anObject cache: ivOffsetCache [
  "Traverse the sub-objects of the given object using the path names of the
 receiver.  This method assumes that the index is not over a set-valued
 instance variable.  For that kind of index, use the traverse:startingAt:into:
 method.  If a nil value is reached before the end of the path, returns the
 incompletePathTraversalObject."

  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'_traverseObject:cache:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> _traverseObject: anObject incompletesInto: incompleteArray incomplete: incomplete [
  "This method assumes that the index is not over a set-valued instance variable."

  "Intended for support of PathSort ... no collection-based terms"

  self shouldNotImplement: #'_traverse:incompletesInto:incomplete:'

]

{ #category : 'Testing' }
CollectionBasedPathEvaluator >> isCollectionBased [
  "Returns true."

  ^ true

]

{ #category : 'Testing' }
CollectionBasedPathEvaluator >> termsRequired [
  "Answer true if receiver requires that instance variables of indexed objects are present "

  ^ self _pathTermsRequired

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> traverse: anObject andCompare: selector with: aValue [
  "Traverse the given object and perform the comparison operation
 on the object at the end of the path and the given value."

  "This method assumes that the index is not over a set-valued instance variable."

  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'traverse:andCompare:with:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> traverse: anObject andCompare: selector withTraverser: aTraverser [
  "Traverse the given object and perform the comparison operation on the object
 at the end of the path and the value obtained by using the traverser."

  "This method assumes that the index is not over a set-valued instance variable and is in support Of QueryExecutor only."

  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'traverse:andCompare:withTraverser:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> traverse: anObject startingAt: offset do: aBlock [
  "Traverse the sub-objects of anObject, using the path names of the receiver
 starting at the path name at the given offset.  Evaluate <aBlock> for each endObject."

  self subclassResponsibility: #'traverse:startingAt:do:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> traverse: anObject startingAt: offset into: resultSet [
  "Traverse the sub-objects of all the objects in the NSC, using the path names
 of the receiver starting at the path term at the given offset.  Add each
 object at the end of the traversal to the result set.  Returns the result
 set."

  self subclassResponsibility: #'traverse:startingAt:into:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> traverseObject: anObject [
  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'traverseObject:'

]

{ #category : 'Traversing' }
CollectionBasedPathEvaluator >> traverseObject: anObject incompletesInto: incompleteArray incomplete: incomplete [
  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'traverseObject:incompletesInto:incomplete:'

]
