Extension { #name : 'CollisionBucket' }

{ #category : 'Repository Conversion' }
CollisionBucket >> fixRefsAfterConversion [

"Default method for fixing references to ObsLargePositiveInteger 
 and ObsLargeNegativeInteger instances that can now be represented
 as a SmallInteger and Floats and SmallFloats which can now be 
 represented as a SmallDouble.  For collision buckets, we send
 the message to our parent Dictionary and let him do the fix up."

|dict result convBm |
convBm := (GsBitmap newForHiddenSet: #Conversion).
(convBm includes: self) 
        ifTrue:[^false]. "already fixed this one"
dict := self keyValueDictionary.
result := false.
dict ~~ nil
        ifTrue:[result := dict fixRefsAfterConversion].
convBm add: self.
^result

]
