Extension { #name : 'EqualityIndexSpecification' }

{ #category : 'accessing' }
EqualityIndexSpecification >> _createIndex [
  | index |
  index := self equalityIndexClass
    newWithLastElementClass: self lastElementClass.
  self legacyIndex
    ifFalse: [ index options: self options ].
  ^ index

]

{ #category : 'private' }
EqualityIndexSpecification >> _validateLastElementClassOn: anNsc [
  | aClass |
  aClass := self lastElementClass.
  aClass _validateClass: Behavior.
  ((aClass canUnderstand: #'<=')
    or: [ aClass == Boolean or: [ aClass == UndefinedObject ] ])
    ifFalse: [ anNsc _error: #'rtErrBagClassDoesNotSupportRangeOperators' args:{aClass} ]

]

{ #category : 'accessing' }
EqualityIndexSpecification >> equalityIndexClass [
  ^ self legacyIndex
    ifTrue: [ RangeEqualityIndex ]
    ifFalse: [ GsRangeEqualityIndex ]

]

{ #category : 'accessing' }
EqualityIndexSpecification >> indexType [

	^#equality

]

{ #category : 'accessing' }
EqualityIndexSpecification >> indexTypePrintString [
  ^ 'equalityIndex'

]

{ #category : 'accessing' }
EqualityIndexSpecification >> removeIndexFrom: anNsc [
  (self isIndexedOn: anNsc)
    ifTrue: [ anNsc removeEqualityIndexOn: self path ]

]
