Extension { #name : 'Gs32Optimizer' }

{ #category : 'visiting' }
Gs32Optimizer >> acceptCompoundClause: aCompoundClause [
  "replace conjunctive normal form clauses with optimized equivalent"

  | clause |
  clause := aCompoundClause clause1.
  clause isDisjunctiveNormalForm
    ifTrue: [
      clause isDisjunctiveClause
        ifTrue: [ clause := self optimizeDisjunctiveCompoundClause: clause ].
      clause := self optimizeDisjunctiveNormalClause: clause.
      aCompoundClause clause1: clause ]
    ifFalse: [
      clause isDisjunctiveClause
        ifTrue: [
          clause := self optimizeDisjunctiveCompoundClause: clause.
          aCompoundClause clause1: clause ] ].
  clause := aCompoundClause clause2.
  clause isDisjunctiveNormalForm
    ifTrue: [
      clause isDisjunctiveClause
        ifTrue: [ clause := self optimizeDisjunctiveCompoundClause: clause ].
      clause := self optimizeDisjunctiveNormalClause: clause.
      aCompoundClause clause2: clause ]
    ifFalse: [
      clause isDisjunctiveClause
        ifTrue: [
          clause := self optimizeDisjunctiveCompoundClause: clause.
          aCompoundClause clause2: clause ] ].
  super acceptCompoundClause: aCompoundClause

]

{ #category : 'optimizing' }
Gs32Optimizer >> optimize [
  | formulaCopy |
  formulaCopy := (GsClassicQueryBlockOptimizer
    optimize: self formula
    on: self nsc
    options: self queryOptions) copy.
  formulaCopy isDisjunctiveNormalForm
    ifTrue: [
      formulaCopy isDisjunctiveClause
        ifTrue: [ formulaCopy := self optimizeDisjunctiveCompoundClause: formulaCopy ].
      formulaCopy := self optimizeDisjunctiveNormalClause: formulaCopy ]
    ifFalse: [
      formulaCopy isDisjunctiveClause
        ifTrue: [ formulaCopy := self optimizeDisjunctiveCompoundClause: formulaCopy ] ].
  self visitFormula: formulaCopy.
  self transformed
    ifTrue: [
      "given the nature of the disjunctive clause transforms, we need to keep optimizing until nothing is changed"
      self formula: formulaCopy copy.
      self transformed: false.
      ^ self optimize ].
  ^ formulaCopy immediateInvariant

]

{ #category : 'optimizing' }
Gs32Optimizer >> optimizeConjunctiveNormalClause: aClause [
  ^ aClause

]

{ #category : 'optimizing' }
Gs32Optimizer >> optimizeDisjunctiveCompoundClause: aClause [
  | optimizer |
  self queryOptions consolidateUnaryConstantPredicates
    ifFalse: [ ^ aClause ].
  (optimizer := Gs32UnaryConstantPredicateOptimizer new)
    formula: aClause;
    nsc: self nsc;
    queryOptions: self queryOptions .
  ^ (optimizer optimizeFrom: self) copy

]

{ #category : 'optimizing' }
Gs32Optimizer >> optimizeDisjunctiveNormalClause: aClause [
  ^ (Gs32DisjunctiveClauseOptimizer
    optimize: aClause
    on: self nsc
    options: self queryOptions) copy

]

{ #category : 'accessing' }
Gs32Optimizer >> transformed [
  transformed ifNil: [ transformed := false ].
  ^transformed

]

{ #category : 'accessing' }
Gs32Optimizer >> transformed: aBool [
  transformed := aBool

]
