Extension { #name : 'Gs32UnaryConstantPredicateOptimizer' }

{ #category : 'optimizing' }
Gs32UnaryConstantPredicateOptimizer >> optimizeFrom: aGs32Optimizer [
  "Simplify compound clause involving predicates that are unary-constant (true or false) or
   constant-constant. The predicate is removed, or the expression is consolidated."

  | truePredicate falsePredicate clause1 clause2 |
  clause1 := self formula clause1.
  clause2 := self formula clause2.
  truePredicate := falsePredicate := nil.
  (clause1 isConstantConstant and: [ clause1 isConstantBound ])
    ifTrue: [
      clause1 executePredicate
        ifTrue: [
          aGs32Optimizer transformed: true.
          ^ clause1 ]
        ifFalse: [
          aGs32Optimizer transformed: true.
          ^ clause2 ] ]
    ifFalse: [
      (clause2 isConstantConstant and: [ clause2 isConstantBound ])
        ifTrue: [
          clause2 executePredicate
            ifTrue: [
              aGs32Optimizer transformed: true.
              ^ clause2 ]
            ifFalse: [
              aGs32Optimizer transformed: true.
              ^ clause1 ] ] ].
  ^ self formula

]
