Extension { #name : 'GsAbstractQueryPredicate' }

{ #category : 'visitors' }
GsAbstractQueryPredicate >> acceptVisitor: aFormulaVisitor [
  super acceptVisitor: aFormulaVisitor.
  aFormulaVisitor acceptPredicate: self

]

{ #category : 'optimizing' }
GsAbstractQueryPredicate >> applyDeMorgansTransform [
  "do not transform, but propagate the transform"

  ^ self

]

{ #category : 'querying-private' }
GsAbstractQueryPredicate >> elementValue: anObject [
  "the pathTerms in the query will use anObject as the starting point ... analagous to an object in the nsc that is bound to a query"

  "with a set-valued path term, we may get multiple evaluations of the block ... a value along the path will result in no evaluation of the block"

  self elementValueEvaluator
    traverse: anObject
    do: [ :resolvedObject |
      | res |
      res := self lastElementValue: resolvedObject.
      res
        ifTrue: [ ^ res ] ].
  ^ false

]

{ #category : 'querying-private' }
GsAbstractQueryPredicate >> elementValueEvaluator [
  "companion method to #elementValue:"

  "anObject is the value obtained by traversing path terms to the last value ... analgous to the last element class"

  "not all subclasses are required to implement this selector, if they do not implement this selector, then they must implement #elementValue:"

  self subclassResponsibility: #'elementValueEvaluator'

]

{ #category : 'testing' }
GsAbstractQueryPredicate >> isPredicate [
  ^ true

]

{ #category : 'querying-private' }
GsAbstractQueryPredicate >> lastElementValue: anObject [
  "companion method to #elementValue:"

  "anObject is the value obtained by traversing path terms to the last value ... analgous to the last element class"

  "not all subclasses are required to implement this selector, if they do not implement this selector, then they must implement #elementValue:"

  self subclassResponsibility: #'lastElementValue:'

]
