Extension { #name : 'GsEventLogSystemEntry' }

{ #category : 'Instance creation' }
GsEventLogSystemEntry class >> new [
	self shouldNotImplement: #new

]

{ #category : 'Testing' }
GsEventLogSystemEntry >> canBeDeleted [
	^false

]

{ #category : 'Actions' }
GsEventLogSystemEntry >> deleteEntry [
	"This protocol does not delete system entries"

	^self

]

{ #category : 'Testing' }
GsEventLogSystemEntry >> isSystemEvent [
	^true

]

{ #category : 'Testing' }
GsEventLogSystemEntry >> isUserEvent [
	^false

]

{ #category : 'Displaying' }
GsEventLogSystemEntry >> printOn: aStream [

	aStream
		nextPutAll: self timestampString;
		tab;
		nextPutAll: self priorityAsLabel;
		tab;
		nextPutAll: '(System) ';
		nextPutAll: self label.

	self object notNil ifTrue:
		[aStream tab; nextPutAll: self object asString].

]

{ #category : 'Accessing' }
GsEventLogSystemEntry >> subsystem [
	^subsystem

]

{ #category : 'Updating' }
GsEventLogSystemEntry >> subsystem: newValue [
	subsystem := newValue

]
