Extension { #name : 'GsOptionalPathTerm' }

{ #category : 'Traversing' }
GsOptionalPathTerm >> _getNextObjectForTraversal: anObject [
  " get the next object along the path "

  | ivOffset nextObj |
  ivOffset := anObject _findIVOffsetForPathTerm: self.
  ivOffset == nil
    ifTrue: [ nextObj := nil ]
    ifFalse: [ nextObj := anObject instVarAt: ivOffset ].
  ^ nextObj

]

{ #category : 'Testing' }
GsOptionalPathTerm >> isOptionalTerm [
  ^ true

]

{ #category : 'Testing' }
GsOptionalPathTerm >> termsRequired [
  "Answer true if receiver requires that instance variables of indexed objects are present "

  ^ false

]
