Extension { #name : 'GsPreparedPathConstantPredicate' }

{ #category : 'querying-private' }
GsPreparedPathConstantPredicate >> elementValue: anObject [
  "the pathTerms in the query will use anObject as the starting point ... analagous to an object in the nsc that is bound to a query"

  "with a set-valued path term, we may get multiple evaluations of the block ... a value along the path will result in no evaluation of the block"

  preparedEvaluator
    traverse: anObject
    cachedOffsets: cachedOffsets
    cachedClasses: cachedClasses
    do: [ :resolvedObject |
      (resolvedObject perform: preparedOperator with: preparedConstant)
        ifTrue: [ ^ true ] ].
  ^ false

]

{ #category : 'private' }
GsPreparedPathConstantPredicate >> prepare [
  "cache all of the objects needed for repeated evaluation within a loop"

  | ivOffsetCache |
  preparedOperator := self operator.
  preparedConstant := self constant.
  preparedOperator == #'unary'
    ifTrue: [ preparedOperator := #'=='.
      preparedConstant := true ].
  preparedOperator == #'unaryNot'
    ifTrue: [ preparedOperator := #'~~'.
      preparedConstant := true ].
  self evaluator optimizingComparison
    ifFalse: [ preparedOperator := self comparisonSelectorFor: preparedOperator ].
  preparedEvaluator := self elementValueEvaluator.
  preparedEvaluatorSize := preparedEvaluator size.
  ivOffsetCache := preparedEvaluator _createIvOffsetCache.
  cachedClasses := ivOffsetCache at: 1.
  cachedOffsets := ivOffsetCache at: 2

]
