Extension { #name : 'GsQueryPathReferenceAssociation' }

{ #category : 'converting' }
GsQueryPathReferenceAssociation >> asArrayOf32PathTerms [
  ^ self key asArrayOf32PathTerms

]

{ #category : 'converting' }
GsQueryPathReferenceAssociation >> asFormula [
  ^ GsPathConstantPredicate new
    path1: self;
    operator: #'unary';
    immediateInvariant

]

{ #category : 'converting' }
GsQueryPathReferenceAssociation >> asFormulaWithSelectorParts: selectorParts arguments: arguments [
  ^ arguments first asReferenceAssociation
    constructFormulaWithSelector: selectorParts first inputValue
    againstPathReferenceAssoction: self

]

{ #category : 'private' }
GsQueryPathReferenceAssociation >> constructFormulaWithSelector: selector againstConstantReferenceAssoction: aConstantReferenceAssociation [
  ^ GsConstantPathPredicate new
    operand1: aConstantReferenceAssociation;
    operator: selector asSymbol;
    path2: self;
    immediateInvariant

]

{ #category : 'private' }
GsQueryPathReferenceAssociation >> constructFormulaWithSelector: selector againstPathReferenceAssoction: aPathReferenceAssociation [
  ^ GsPathPathPredicate new
    path1: aPathReferenceAssociation;
    operator: selector asSymbol;
    path2: self;
    immediateInvariant

]

{ #category : 'testing' }
GsQueryPathReferenceAssociation >> hasEnumeratedTerm [
  self asArrayOf32PathTerms
    do: [ :term |
      (term includes: $|)
        ifTrue: [ ^ true ] ].
  ^ false

]

{ #category : 'testing' }
GsQueryPathReferenceAssociation >> hasSamePathAs: aReferenceAssoc [
  (aReferenceAssoc isKindOf: self class)
    ifFalse: [ ^ false ].
  ^ self key = aReferenceAssoc key

]
