Extension { #name : 'GsQueryTokenParser' }

{ #category : 'initialization' }
GsQueryTokenParser class >> _initialize [
        SeparatorPredicate := PPCharSetPredicate on: [ :char | char isSeparator ]

]

{ #category : 'parsing' }
GsQueryTokenParser >> parseOn: aStream [
  | start token |
  [ aStream atEnd not and: [ SeparatorPredicate value: aStream uncheckedPeek ] ]
    whileTrue: [ aStream next ].
  start := aStream position.
  token := super parseOn: aStream.
  token isPetitFailure
    ifTrue: [
      aStream position: start.
      ^ token ].
  ^ token

]
