"
GsTestResult is the GemStone-specific refinement of the SUnit TestResult class.
"
Class {
	#name : 'GsTestResult',
	#superclass : 'TestResult',
	#instVars : [
		'defects'
	],
	#gs_options : [
		'instancesNonPersistent'
	],
	#category : 'Kernel'
}

{ #category : 'Debugging' }
GsTestResult class >> defectLogFile [
	^ SessionTemps current at: #GsTestResultDefectsLog
		ifAbsentPut: [ 
			| f |
			f := GsFile openAppendOnServer: 'SUnitDefects.log'.
			f ifNil: [ Error signal: 'open failed' , GsFile serverErrorString ].
			f ]
]

{ #category : 'Adding' }
GsTestResult >> addDefect: aTestCase [
	"uncomment to debug test framework"
	"nil pause . "
	self logDefect: aTestCase.
	self defects add: aTestCase printString	"don't keep aTestCase alive in memory"
]

{ #category : 'Adding' }
GsTestResult >> addError: aTestCase [
  "nil pause . ""uncomment to debug test framework"
  self addDefect: aTestCase.
  super addError: aTestCase printString  "don't keep aTestCase alive in memory"
]

{ #category : 'Adding' }
GsTestResult >> addFailure: aTestCase [
  "nil pause. ""uncomment to debug test framework"
  self addDefect: aTestCase.
  super addFailure: aTestCase printString "don't keep aTestCase alive in memory"
]

{ #category : 'Adding' }
GsTestResult >> addPass: aTestCase [
  ^self passed add: aTestCase printString  "don't keep aTestCase alive in memory"
]

{ #category : 'Accessing' }
GsTestResult >> defects [
	^ defects ifNil: [ defects := NonPersistentArray new ]
]

{ #category : 'Accessing' }
GsTestResult >> errors [
	^ errors ifNil: [ errors := NonPersistentArray new ]
]

{ #category : 'Accessing' }
GsTestResult >> failures [
	^ failures ifNil: [ failures := NonPersistentArray new ]
]

{ #category : 'Testing' }
GsTestResult >> isError: aTestCase [
	"Unlike my superclass, I do not retain test instances."
	self shouldNotImplement: #isError:
]

{ #category : 'Testing' }
GsTestResult >> isFailure: aTestCase [
	"Unlike my superclass, I do not retain test instances."
	self shouldNotImplement: #isFailure:
]

{ #category : 'Testing' }
GsTestResult >> isPassed: aTestCase [
	"Unlike my superclass, I do not retain test instances."
	self shouldNotImplement: #isPassed:
]

{ #category : 'Logging' }
GsTestResult >> logDefect: aTestCase [
  GsFile stdoutServer isTerminal ifFalse:[ | path idx dir str ver |
	  path := (System gemEnvironmentVariable: 'resultdir') ifNil:[ GsFile serverCurrentDirectory ].
		self class defectLogFile ifNotNil: [ :f | 
      dir := '' .
			idx := path indexOfLastByte: $/ codePoint startingAt: path size.
      idx ~~ 0 ifTrue:[
			  dir := path copyFrom: idx + 1 to: path size.
      ].
			ver := System _gemVersion.
			idx := ver indexOf: $, startingAt: 1.
			ver := ver copyFrom: 1 to: idx - 1.
			str := ver , ', ' , System hostname , ', ' , dir , ', ' , aTestCase printString,'   ', Time now asStringMs .
			f nextPutAll: str lf;
						flush 
    ] 
  ] ifTrue: [ 
	   "interactive, don't log"
	]
]

{ #category : 'Accessing' }
GsTestResult >> passed [
	^ passed ifNil: [ passed := NonPersistentArray new ]
]

{ #category : 'Running' }
GsTestResult >> runCase: aTestCase [
	| aPass |
	[ 
	aTestCase runCase.
	aPass := true.
	self passed add: aTestCase ]
		on: Error , TestFailure , Notification
		do: [ :ex | 
			aPass ifNotNil: [ System waitForDebug ].
			ex class defaultHandlers size > 0
				ifTrue: [ ex pass ].
			(ex isKindOf: TestFailure)
				ifTrue: [ self addFailure: aTestCase ]
				ifFalse: [ self addError: aTestCase ].
			GsTestCase logCr: 'ERROR ' , ex number asString , '  ' , ex asString.
			(GsTestCase isDebug: ex)
				ifFalse: [ 
					GsTestCase
						logCr: '------------------------------(';
						logCr: (GsProcess stackReportToLevel: 300);
						"Uncomment this to get more output in SUnit.log:"
						"logCr: (GsProcess _fullStackReport );"
						logCr: '------------------------------)' ].
			"uncomment for attach with DEBUGGEM"
			"GsFile gciLogServer:'WAITING for topaz to attach'.
			[ true ] whileTrue:[ Delay waitForSeconds: 1 ]."
			self ]
]
