Extension { #name : 'GsUnicodeRangeEqualityIndex' }

{ #category : 'instance creation' }
GsUnicodeRangeEqualityIndex class >> newWithCollator: anIcuCollator [
  "Create a new instance and initialize its B-tree root."

  | newOne |
  newOne := super new.
  newOne collator: anIcuCollator.
  ^ newOne

]

{ #category : 'instance creation' }
GsUnicodeRangeEqualityIndex class >> newWithLastElementClass: aClass [
  self shouldNotImplement: #'newWithLastElementClass:'

]

{ #category : 'Testing' }
GsUnicodeRangeEqualityIndex >> _canCompareWith: aKey [
  "Returns whether the receiver can make B-tree comparisons with the given key."

  self constraintType == #unicodeString
    ifTrue: [ ^ super _canCompareWith: aKey ].
  ^ btreeRoot _canCompare: aKey withClass: Unicode7

]

{ #category : 'Index Creation' }
GsUnicodeRangeEqualityIndex >> _preIndexCreationSort [
  | btreeRootNode |
  true
    ifTrue: [
      "skip pre-sort for now"
      ^ self btreeRoot ].
  btreeRootNode := (PathSorter
    on: {self}
    directions: #(true)
    collator: self collator)
    lastNodeOffset: 1;
    yourself.
  ^ self btreeRoot
    btreeRootNode: btreeRootNode;
    collator: self collator;
    yourself

]

{ #category : 'conversion' }
GsUnicodeRangeEqualityIndex >> asIndexSpecification [
  ^ (UnicodeIndexSpecification
    path: self pathComponentsString
    collator: self collator)
    options: self options;
    constraintType: self constraintType;
    yourself

]

{ #category : 'Stream Accessing' }
GsUnicodeRangeEqualityIndex >> btreeComparisonQuerySpec [
  ^ BtreePlusUnicodeComparisonQuerySpec new
    collator: self collator;
    rangeIndex: self;
    yourself

]

{ #category : 'Stream Accessing' }
GsUnicodeRangeEqualityIndex >> btreeRangeComparisonQuerySpec [
  ^ BtreePlusUnicodeRangeComparisonQuerySpec new
    rangeIndex: self;
    collator: self collator;
    yourself

]

{ #category : 'Accessing' }
GsUnicodeRangeEqualityIndex >> collator [
  "Returns IcuCollator to be used when comparing Unicode strings"

  ^ collator ifNil: [ collator := IcuCollator default copy immediateInvariant ]

]

{ #category : 'Accessing' }
GsUnicodeRangeEqualityIndex >> collator: anIcuCollator [
  "Set the receiver's collator. Use a copy of anIcuCollator to disallow
   changes to strength, etc, that might affect the sort ordering. "

  collator := anIcuCollator copy immediateInvariant

]

{ #category : 'Comparison Operators' }
GsUnicodeRangeEqualityIndex >> comparisonForCompare [
  ^ BtreeComparisonForUnicodeCompare new
      collator: self collator;
      yourself

]

{ #category : 'Comparison Operators' }
GsUnicodeRangeEqualityIndex >> comparisonForSort [
  "called during creation of receiver, so initialize unset instance variables"

  ^ comparisonForSort
      ifNil: [ comparisonForSort := BtreeComparisonForCompare newForSort: self collator ]

]

{ #category : 'Accessing' }
GsUnicodeRangeEqualityIndex >> constraintType: aSymbolOrNil [
  "Set the constraintType, either #unicodeString or nil."

  (aSymbolOrNil ~~ #'unicodeString' and: [ aSymbolOrNil ~~ nil ])
    ifTrue: [
      ArgumentError
        signal:
          self class name asString , ' constraintType must #unicodeString or nil' ].
  constraintType := aSymbolOrNil

]

{ #category : 'Accessing' }
GsUnicodeRangeEqualityIndex >> lastElementClassDescription [
  "answer a description of the lastElementClass of the receiver,
   suitable for use in an error message"

  | qualifier |
  qualifier := ''.
  self optimizingComparison ifTrue: [ qualifier := ' [ with optimized comparison ]'. ].
  ^ 'CharacterCollection including Unicode String classes', qualifier

]

{ #category : 'Testing' }
GsUnicodeRangeEqualityIndex >> optimizingComparison [
  "Unicode classes can be optimized, just check that option has been specified"

  ^ optimizingComparison ifNil: [ optimizingComparison := self options optimizedComparison ]

]
