Extension { #name : 'GsVariableReferenceAssociation' }

{ #category : 'converting' }
GsVariableReferenceAssociation >> asFormula [
  ^ GsConstantConstantPredicate new
    constant1: self;
    operator: #'unary';
    immediateInvariant

]

{ #category : 'accessing' }
GsVariableReferenceAssociation >> bind: variableName to: anObject [
  variableName = self key
    ifFalse: [ ^ self ].
  bound := true.
  self value: anObject

]

{ #category : 'accessing' }
GsVariableReferenceAssociation >> bound [
  bound ifNil: [ ^ false ].
  ^ bound

]

{ #category : 'testing' }
GsVariableReferenceAssociation >> isBound [
  ^ self bound

]

{ #category : 'accessing' }
GsVariableReferenceAssociation >> unbind [
  "remove all bindings"

  bound := false.
  self value: nil

]

{ #category : 'accessing' }
GsVariableReferenceAssociation >> value [
  self bound
    ifFalse: [ self error: 'Variable: ' , self key printString , ' not bound' ].
  ^ super value

]
