"
A hash tree set tree walker is dbTransient and specialized for use
as part of a TreeSet.
"
Class {
	#name : 'HtSetTreeWalker',
	#superclass : 'HtTreeWalker',
	#gs_options : [
		'dbTransient'
	],
	#category : 'HashTree-Core'
}

{ #category : 'private-updating' }
HtSetTreeWalker >> searchInternalNode: node isFinalSibling: nodeIsFinal forAdd: key withHash: hash [
	| child childIndex maxIndex nextHash newChildNode |
	childIndex := node lowestChildIndexForHash: hash.
	nextHash := hash.
	maxIndex := node maxChildIndex.
	newChildNode := nil.
	[ nextHash = hash and: [ childIndex <= maxIndex and: [ found not ] ] ]
		whileTrue: [ 
			child := node at: childIndex.
			nextHash := node at: childIndex + 1.

			newChildNode := self
				searchNode: child
				isFinalSibling: (nodeIsFinal and: [ nextHash > hash ])
				forAdd: key
				withHash: hash.
			childIndex := childIndex + 2 ].
	nodeIsFinal
		ifFalse: [ ^ nil ].
	newChildNode ifNil: [ ^ nil ].
	node insertChildNode: newChildNode atIndex: childIndex.
	^ node isFull
		ifTrue: [ node split ]
		ifFalse: [ nil ]
]

{ #category : 'private-query' }
HtSetTreeWalker >> searchLeafNode: node forValueAt: key withHash: hash [

	| index keyFound |
	index := node indexForKey: key withHash: hash.
	keyFound := node at: index.
	keyFound == nil ifFalse: [
		found := true.
		value := keyFound ]
]

{ #category : 'private-updating' }
HtSetTreeWalker >> searchLeafNode: node isFinalSibling: nodeIsFinal forAdd: key withHash: hash [
	| index keyFound |
	index := node indexForKey: key withHash: hash.
	keyFound := node at: index.
	keyFound
		ifNotNil: [ 
			found := true.	"Already present; done."
			^ nil ].	

	"If key is not yet found and I'm the last leaf to be searched, add the key."
	nodeIsFinal
		ifFalse: [ ^ nil ].
	node addKey: key atKeyIndex: index.
	^ node isFull
		ifTrue: [ node split ]
		ifFalse: [ nil ]
]

{ #category : 'private-removing' }
HtSetTreeWalker >> searchLeafNode: node isFinalSibling: nodeIsFinal forRemoveKey: key withHash: hash [
	| index keyFound |
	index := node indexForKey: key withHash: hash.
	keyFound := node at: index.
	keyFound
		ifNotNil: [ 
			found := true.
			value := keyFound.
			node removeKeyAt: index ].
	^ node percentFull
]

{ #category : 'private-updating' }
HtSetTreeWalker >> searchNode: node isFinalSibling: nodeIsFinal forAdd: key withHash: hash [
	^ node isLeaf
		ifTrue: [ 
			self
				searchLeafNode: node
				isFinalSibling: nodeIsFinal
				forAdd: key
				withHash: hash ]
		ifFalse: [ 
			self
				searchInternalNode: node
				isFinalSibling: nodeIsFinal
				forAdd: key
				withHash: hash ]
]

{ #category : 'public' }
HtSetTreeWalker >> searchTree: rootNode toAdd: key withHash: hash [
	"Root node has no siblings, so is always the final sibling."

	| newNode |
	found := false.
	newNode := self
		searchNode: rootNode
		isFinalSibling: true
		forAdd: key
		withHash: hash.
	found := false.
	^ newNode
]
