Extension { #name : 'IdentityBtreeNode' }

{ #category : 'ObsoleteIDX - Searching' }
IdentityBtreeNode >> _binarySearchCoveringKey: aKey [

"Returns the index for the first entry in which aKey is found utilizing a
 binary search.  This is the first entry whose key >= aKey."

" <primitive: WAS 356> "

self _primitiveFailed: #_binarySearchCoveringKey: args: { aKey } .
self _uncontinuableError

]

{ #category : 'ObsoleteIDX - Searching' }
IdentityBtreeNode >> _binarySearchForKey: aKey [

"Returns the 'value' index whose key is identical to aKey.  If no match is
 found, returns zero.  Uses a binary search."

"<primitive: WAS 357> "

self _primitiveFailed: #_binarySearchForKey: args: { aKey } .
self _uncontinuableError

]

{ #category : 'ObsoleteIDX - Accessing' }
IdentityBtreeNode >> at: aKey otherwise: otherValue [

"Returns the value that corresponds to aKey by searching the elements in the
 bucket.  If no such key/value pair exists, returns the given alternate value."

  | valueIndex |
  valueIndex := self _binarySearchForKey: aKey.
  valueIndex == 0 ifTrue: [
    ^ otherValue
  ].
  ^ self _at: valueIndex

]

{ #category : 'ObsoleteIDX - Updating' }
IdentityBtreeNode >> at: aKey put: aValue [

"Adds the key/value pair to the node.  If the node is full, raises an error."

  | index |
  " determine if full "
  numElements == self class maxNumberOfElements
    ifTrue: [
      ^ self _error: #objErrMaxSize
	  args: { numElements + 1 . self class maxNumberOfElements }
    ]
    ifFalse: [ " entry will fit in leaf node "
      numElements == 0
	ifTrue: [ index := 1 ]
	ifFalse: [ index := self _binarySearchCoveringKey: aKey ].
      self _insertKey: aKey value: aValue atIndex: index
    ].

]

{ #category : 'ObsoleteIDX - Private' }
IdentityBtreeNode >> dynamicInstVarAt: aSymbol [

self shouldNotImplement: #dynamicInstVarAt: "conflicts with use of _tagAt: "

]

{ #category : 'ObsoleteIDX - Private' }
IdentityBtreeNode >> dynamicInstVarAt: aSymbol put: aValue [

self shouldNotImplement: #dynamicInstVarAt:put: "conflicts with use of _tagAt:put: "

]

{ #category : 'ObsoleteIDX - Private' }
IdentityBtreeNode >> parent [

"Returns the back pointer to the parent."

" Stored in the tag slot so that we do not disturb binary search in C."
^ self _tagAt: 1

]

{ #category : 'ObsoleteIDX - Private' }
IdentityBtreeNode >> parent: anObj [

"Sets the parent of the receiver."

" Stored in the tag slot so that we do not disturb binary search in C."
self _tagAt: 1 put: anObj

]

{ #category : 'ObsoleteIDX - Removing' }
IdentityBtreeNode >> removeKey: aKey ifAbsent: block [

"Removes the key/value pair.  Finds the index for the given key and then shifts
 any following entries to the left."

  | result valueIndex |
  valueIndex := self _binarySearchForKey: aKey.
  valueIndex == 0 ifTrue: [
    ^ block value
  ].
  result := self _at: valueIndex.
  self _deleteNoShrinkFrom: valueIndex to: valueIndex + self entrySize - 1 .
  numElements := numElements - 1.
  ^ result

]

{ #category : 'ObsoleteIDX - Removing' }
IdentityBtreeNode >> removeKey: aKey otherwise: otherVal [

"Removes the key/value pair.  Finds the index for the given key and then shifts
 any following entries to the left."

  | result valueIndex |
  valueIndex := self _binarySearchForKey: aKey.
  valueIndex == 0 ifTrue: [
    ^ otherVal
  ].
  result := self _at: valueIndex.
  self _deleteNoShrinkFrom: valueIndex to: valueIndex + self entrySize - 1 .
  numElements := numElements - 1.
  ^ result

]
