Extension { #name : 'IndexManagerAutoCommitPolicy' }

{ #category : 'Instance Creation' }
IndexManagerAutoCommitPolicy class >> on: anIndexManager [

^ self new indexManager: anIndexManager

]

{ #category : 'Accessing' }
IndexManagerAutoCommitPolicy >> dirtyObjectCommitThreshold [

^ dirtyObjectCommitThreshold

]

{ #category : 'Evaluation' }
IndexManagerAutoCommitPolicy >> evaluate: aBlock for: anIndexManager [
  | thresh |
  (thresh := percentTempObjSpaceCommitThreshold) ifNil: [
    "no % memory threshold protection"
    [
      [ TransactionBacklog enableSignalling.
        aBlock value ]
        onException: TransactionBacklog
        do: [ :ex |
          anIndexManager _doCommit.
          TransactionBacklog enableSignalling.
          ex resume ] 
     ] ensure: [ TransactionBacklog disableSignalling ] 
  ] ifNotNil: [ | saveAoom saveThresh |
    thresh := thresh min: (saveThresh := AlmostOutOfMemoryError threshold) .
    saveAoom := AlmostOutOfMemoryError enabled.
    [
      [ TransactionBacklog enableSignalling.
        aBlock value 
      ] onException: { AlmostOutOfMemoryError enableAtThreshold: thresh . 
                       TransactionBacklog }
        do: { 
         [ :ex | | systm |
          anIndexManager _doCommit.	
           (systm := System) _vmMarkSweep.
           systm _tempObjSpacePercentUsedLastMark < thresh ifTrue: [
						 "dropped below the threshold, reenable the signal"
						 AlmostOutOfMemoryError enable 
           ] ifFalse: [
             "likely started already above the threshold
             and commits won't necessarily help with out of memory problems"
           ] .
           ex resume 
         ] .
         [:ex | 
           anIndexManager _doCommit.	"get the commit out of the way"
           TransactionBacklog enableSignalling .
           ex resume 
         ] 
        }
     ] ensure: [
         TransactionBacklog disableSignalling.
         saveAoom ifFalse:[ AlmostOutOfMemoryError disable ]
                 ifTrue:[ AlmostOutOfMemoryError enableAtThreshold: saveThresh].
     ] 
  ]

]

{ #category : 'Initialization' }
IndexManagerAutoCommitPolicy >> indexManager: anIndexManager [

dirtyObjectCommitThreshold := anIndexManager dirtyObjectCommitThreshold.
percentTempObjSpaceCommitThreshold := anIndexManager percentTempObjSpaceCommitThreshold.

]

{ #category : 'Accessing' }
IndexManagerAutoCommitPolicy >> percentTempObjSpaceCommitThreshold [

^ percentTempObjSpaceCommitThreshold

]

{ #category : 'Testing' }
IndexManagerAutoCommitPolicy >> shouldCommit [
  "Answer true if enough dirty objects have been modified, or memory is close to full."

  "do not look at % memory used, since we use an exception handler for AlmostOutOfMemory"

 ^ System _numPersistentObjsModified > dirtyObjectCommitThreshold

]
