Extension { #name : 'PPForwardingParser' }

{ #category : 'instance creation' }
PPForwardingParser class >> to: forwardee [

	^self new forwardee: forwardee

]

{ #category : 'forwarding' }
PPForwardingParser >> doesNotUnderstand: messageDescriptor [
	"Forward them all"

	^forwardee
		perform: (messageDescriptor at: 1)
		env: 0
		withArguments: (messageDescriptor at: 2)

]

{ #category : 'accessing' }
PPForwardingParser >> forwardee: aParser [

	forwardee := aParser

]

{ #category : 'testing' }
PPForwardingParser >> isPetitParser [
	"Must override Object's implementation, or forward. Easier to override."

	^true

]
