Extension { #name : 'PPLiteralObjectParser' }

{ #category : 'operators' }
PPLiteralObjectParser >> caseInsensitive [
	"Answer a parser that can parse the receiver case-insensitive."

	literal asUppercase = literal asLowercase ifTrue: [ ^ self ].
	^ PPPredicateObjectParser on: [ :value | literal "sameAs:" isEquivalent: value ] message: message

]

{ #category : 'operators' }
PPLiteralObjectParser >> negate [
	^ (PPPredicateObjectParser expect: literal message: message) negate

]

{ #category : 'parsing' }
PPLiteralObjectParser >> parseOn: aPPContext [
	^ (aPPContext stream atEnd not and: [ literal = aPPContext stream uncheckedPeek ])
		ifFalse: [ PPFailure message: message context: aPPContext ]
		ifTrue: [ aPPContext next ]

]
