Extension { #name : 'PPRepeatingParser' }

{ #category : 'initialization' }
PPRepeatingParser >> initialize [
	super initialize.
	self setMin: 0; setMax: SmallInteger "maxVal" maximumValue

]

{ #category : 'accessing' }
PPRepeatingParser >> max [
	"Answer the maximum number of repetitions."

	^ max

]

{ #category : 'accessing' }
PPRepeatingParser >> min [
	"Answer the minimum number of repetitions."

	^ min

]

{ #category : 'printing' }
PPRepeatingParser >> printOn: aStream [
	super printOn: aStream.
	aStream nextPutAll: ' ['; print: min; nextPutAll: ', '; nextPutAll: (max = SmallInteger "maxVal" maximumValue
		ifTrue: [ '*' ] ifFalse: [ max printString ]); nextPut: $]

]

{ #category : 'initialization' }
PPRepeatingParser >> setMax: anInteger [
	max := anInteger

]

{ #category : 'initialization' }
PPRepeatingParser >> setMin: anInteger [
	min := anInteger

]
