Extension { #name : 'ProcessorScheduler' }

{ #category : 'Private' }
ProcessorScheduler >> _initCriticalMethods [

  "Methods which an in-process debugger should not set breakpoints in nor
    single step through.  

  The method compiler omits check interrupt bytecodes that would otherwise be 
  generated when compiling an instance method in ProcessorScheduler.
  Interrupt check on backwards branches are generated in those instance methods.
"
  | arr set |
  arr := {
    "primitive 457"
    CriticalSection  . #_scheduler .
    Delay  . #_scheduler .
    Delay class  . #_scheduler .
    GsProcess  . #_scheduler .
    GsProcess class  . #_scheduler .
    GsSocket  . #_scheduler .
    Processor class  . #_scheduler .
    ProcessorScheduler class  . #scheduler .
    Semaphore  . #_scheduler .

    "senders scheduler"
    AbstractException  . #_signalTimeout: .
    GcFinalizeNotification . #_signalGcFinalize: .
    AbstractException . #_signalAsync: .

    ProcessorScheduler class  . #topazAllProcesses .
    ProcessorScheduler class  . #topazStatusForProcess: .
    ProcessorScheduler class  . #_allProcessesTerminate9 .

    "senders _scheduler"
    CriticalSection  . #critical: .
    Delay  . #signal .
    Delay  . #_cancel: .
    Delay  . #_finishDelay .
    Delay  . #_wait: .
    Delay class  . #waitForMilliseconds: .
    Delay class  . #waitForSeconds: .
    Delay class  . #waitUntilMilliseconds: .
    Delay class  . #_highPriorityWaitForMilliseconds: .
    GsNMethod class  . #_terminateNonForkedProcess .
    GsProcess  . #priority: .
    GsProcess  . #resume .
    GsProcess  . #suspend .
    GsProcess  . #terminate .
    GsProcess  . #_finishDelay .
    GsProcess  . #_newGroup .
    GsProcess  . #_raisePriority .
    GsProcess  . #_reapSignal: .
    GsProcess  . #_signalAll .
    GsProcess  . #_signalJoiners .
    GsProcess  . #_start .
    GsProcess  . #_statusString .
    GsProcess  . #_stepOverInFrame:mode:replace:tos:breakpointLevel: .
    GsProcess  . #_unscheduleProcess .
    GsProcess  . #_wait .
    GsProcess class  . #_forkBlock:with:env:prio: .
    GsProcess class  . #_newForBlock:with:env: .
    GsSocket  . #readWillNotBlockWithin: .
    GsSocket  . #writeWillNotBlockWithin: .
    GsSocket  . #_waitForReadReady .
    GsSocket  . #_waitForWriteReady .
    Processor class  . #activePriority .
    Processor class  . #activeProcess .
    Processor class  . #allProcesses .
    Processor class  . #cancelWhenReadable:signal: .
    Processor class  . #cancelWhenWritable:signal: .
    Processor class  . #highestPriority .
    Processor class  . #highIOPriority .
    Processor class  . #lowestPriority .
    Processor class  . #lowIOPriority .
    Processor class  . #readyProcesses .
    Processor class  . #suspendedProcesses .
    Processor class  . #systemBackgroundPriority .
    Processor class  . #timingPriority .
    Processor class  . #userBackgroundPriority .
    Processor class  . #userInterruptPriority .
    Processor class  . #userSchedulingPriority .
    Processor class  . #waitingProcesses .
    Processor class  . #whenReadable:signal: .
    Processor class  . #whenWritable:signal: .
    Processor class  . #yield .
    Semaphore  . #highPriorityWaitForMilliseconds: .
    Semaphore  . #signal .
    Semaphore  . #signalAll .
    Semaphore  . #wait .
    Semaphore  . #waitForMilliseconds: .

    "implem _exitCritical"
    ProcessorScheduler  . #_exitCritical .
    Semaphore  . #_exitCritical .

    "senders _exitCritical"
    Delay  . #_wait: .
    Delay class  . #_highPriorityWaitForMilliseconds: .
    GsProcess  . #_signalJoiners .
    GsProcess  . #_stepOverInFrame:mode:replace:tos:breakpointLevel: .
    GsProcess  . #_trimStackToLevel:abandonActiveUnwind:numTries:timeout: .
    GsProcess  . #_finishTermination: .
    GsProcess  . #_executeUnwindBlk:numTries:timeout:stack:topFp:resumeCnt: .
    GsProcess  . #_waitingOn: .
    GsProcess  . #_waitForActiveUnwind:timeoutMs:numTries:resumeCnt: .

    ProcessorScheduler  . #waitingProcesses .
    ProcessorScheduler  . #_allProcessesInto: .
    ProcessorScheduler  . #_allProcessesInto:inGroup: .
    ProcessorScheduler  . #_terminateScheduledProcess: .
    ProcessorScheduler  . #_waitForMilliseconds: .
    ProcessorScheduler  . #_waitForSocket:timeout:forWrite: .
    ProcessorScheduler  . #yield .
    ProcessorScheduler  . #_findReadyProcess .
    ProcessorScheduler  . #_findReadyProcessForExit: .
    ProcessorScheduler  . #_runNextProcess .
    ProcessorScheduler  . #_yieldForTimeout .
    Semaphore  . #highPriorityWaitForMilliseconds: .
    Semaphore  . #signal .
    Semaphore  . #signalAll .
    Semaphore  . #wait .
    Semaphore  . #waitForMilliseconds: .

    "primitive 737"
    ProcessorScheduler  . #_exitCritical .

    "primitive 693"
    GsProcess . #_current  .
    GsProcess class . #_current  .
    ProcessorScheduler . #activeProcess  .

    "primitive 169"
    ProcessorScheduler . #_enterCritical  .

    "primitive 736"
    ProcessorScheduler . #waitingProcesses  .
    ProcessorScheduler . #yield  .
    ProcessorScheduler . #_allProcessesInto:  .
    ProcessorScheduler . #_allProcessesInto:inGroup:  .
    ProcessorScheduler . #_runNextProcess  .
    ProcessorScheduler . #_terminateScheduledProcess:  .
    ProcessorScheduler . #_yieldForTimeout  .
    ProcessorScheduler . #readyProcesses  .
    Semaphore . #signal  .
    Semaphore . #signalAll  .
    Semaphore . #wait  .

   "senders _reschedule"
    ProcessorScheduler . #_suspendProcess:  .
    ProcessorScheduler . #_waitForMilliseconds:  .
    ProcessorScheduler . #_waitForSocket:  .
    ProcessorScheduler . #_waitForSocket:timeout:forWrite:  .
    ProcessorScheduler . #_waitOnSema:  .


    "other"
    ProcessorScheduler  . #_reapEvents: .
    ProcessorScheduler  . #_checkForExpiredDelays: .
    ProcessorScheduler . #_now  .
    ProcessorScheduler . #_timeoutNow:  .
    ProcessorScheduler . #_delayUnschedule:  .
    ProcessorScheduler . #_switchFrom:to:  .
    ProcessorScheduler . #_runNextProcess  .
    ProcessorScheduler . #_rescheduleContinue: .
    ProcessorScheduler . #_reschedule  .
    ProcessorScheduler . #_doPoll:yield:  .
    ProcessorScheduler . #_isWhenReadableSet:signal:  .
    ProcessorScheduler . #_isWhenWritableSet:signal:  .
    ProcessorScheduler . #whenReadable:signal:  .
    ProcessorScheduler . #whenWritable:signal:  .
    ProcessorScheduler . #cancelWhenReadable:signal:  .
    ProcessorScheduler . #cancelWhenWritable:signal:  .
    ProcessorScheduler . #_unschedule:  .
    ProcessorScheduler . #_suspendNewProcess:  .
    ProcessorScheduler . #_resumeProcess:  .
    ProcessorScheduler . #_resumeForTermination:resumeCnt:  .
    ProcessorScheduler . #suspendedProcesses  .
    ProcessorScheduler . #_add:toSet:  .
    ProcessorScheduler . #_remove:fromSet:  .
    ProcessorScheduler . #_changePriority:from:  .
    ProcessorScheduler . #_addReadyProcess:to:  .
    ProcessorScheduler . #_addDelay:to:  .
    ProcessorScheduler . #_updateTimerThread:priority:  .
    ProcessorScheduler . #_sizeNoShrink:  .
    ProcessorScheduler . #_allStacksReport .

    GsProcess .  #resume  .

    GsProcess class . #_newForBlock:with:env:  .
    GsProcess . #_init:args:env:stackSerial:forked:  .
    GsProcess class . #_forkBlock:with:env:prio:  .
    ProcessorScheduler . #_scheduleNewProcess:prio:
  }.
  set := IdentitySet new .
  1 to: arr size by: 2 do:[:n |
    | cls sel meth |
    cls := arr at: n .
    sel := arr at: n + 1 .
    meth := cls compiledMethodAt: sel otherwise: nil .
    meth ifNotNil:[ set add: meth ]
         ifNil:[ Error signal: sel , ' not found in ' , cls name  ].
  ].
  criticalMethods := set .
  ^ set

]
