Extension { #name : 'ReferencingObjectPolicy' }

{ #category : 'Public' }
ReferencingObjectPolicy >> addReferencingClass: aClass [

	aClass implementationFormat even	"OOP or NSC"
		ifTrue: [referencingClassHistories add: aClass classHistory]
		ifFalse: [self error: aClass name , ' not supported as a referencing class for Canonicalization'].

]

{ #category : 'Public' }
ReferencingObjectPolicy >> addReferencingClasses: aCollection [

	aCollection do: [:each |
		referencingClassHistories add: each classHistory.
	].

]

{ #category : 'Cleanup' }
ReferencingObjectPolicy >> canonicalizeReferencesIn: aReferencingObject [

	| counter |
	(referencingClassHistories includes: aReferencingObject class classHistory) ifFalse: [^self].
	manager sessionCacheStatAt: 5 incrementBy: 1.		"count of referencing objects scanned during cleanup"
	aReferencingObject isInvariant ifTrue: [
		manager sessionCacheStatAt: 8 incrementBy: 1.	"count of invariant referencing objects scanned during cleanup"
		^self
	].
	counter := aReferencingObject _canonicalizeReferencesUsingPolicy: self.
	counter == 0 ifTrue: [^self].
	manager
		sessionCacheStatAt: 6 incrementBy: 1;				"count of referencing objects changed during cleanup"
		sessionCacheStatAt: 7 incrementBy: counter;		"count of references changed during cleanup"
		yourself.

]

{ #category : 'Cleanup' }
ReferencingObjectPolicy >> canonicalizeReferencesInCollection: aCollection [

	| counter |
	counter := 0.
	aCollection copy do: [:each |
		each isSpecial ifFalse: [
			| canonical |
			(canonical := manager canonicalObjectFor: each) ~~ each ifTrue: [
				aCollection removeIdentical: each; add: canonical.
				counter := counter + 1.
			].
		].
	].
	^counter

]

{ #category : 'Cleanup' }
ReferencingObjectPolicy >> canonicalizeReferencesInDictionary: aDictionary [

	| counter |
	counter := 0.
	aDictionary copy keysAndValuesDo: [:key :value |
		| newKey |
		newKey := key.
		key isSpecial ifFalse: [
			| canonical |
			(canonical := manager canonicalObjectFor: key) ~~ key ifTrue: [
				aDictionary removeKey: key; at: canonical put: value.
				newKey := canonical.
				counter := counter + 1.
			].
		].
		value isSpecial ifFalse: [
			| canonical |
			(canonical := manager canonicalObjectFor: value) ~~ value ifTrue: [
				aDictionary removeKey: newKey; at: newKey put: canonical.
				counter := counter + 1.
			].
		].
	].
	^counter

]

{ #category : 'Cleanup' }
ReferencingObjectPolicy >> canonicalizeReferencesInObject: anObject [

	| counter |
	counter := 0.
	1 to: anObject _primitiveSize do: [:i |
		| each |
		each := anObject _primitiveAtNoFault: i otherwise: nil.
		each isSpecial ifFalse: [
			| canonical |
			(canonical := manager canonicalObjectFor: each) ~~ each ifTrue: [
				anObject _primitiveAt: i put: canonical.
				counter := counter + 1.
			].
		].
	].
	^counter

]

{ #category : 'Initialization' }
ReferencingObjectPolicy >> initialize: aManager [

	referencingClassHistories := IdentitySet new.
	super initialize: aManager.		"This will set the objectSecurityPolicy"

]

{ #category : 'Security' }
ReferencingObjectPolicy >> objectSecurityPolicy: anObjectSecurityPolicy [

	super objectSecurityPolicy: anObjectSecurityPolicy.
	referencingClassHistories objectSecurityPolicy: anObjectSecurityPolicy.

]

{ #category : 'Accessors' }
ReferencingObjectPolicy >> referencingClasses [

	^referencingClassHistories
		inject: IdentitySet new
		into: [:sum :each | sum addAll: each. sum].

]
