Extension { #name : 'SoftReference' }

{ #category : 'Instance creation' }
SoftReference class >> new [

 " creates a new instance with inUse set to false,
   useCount set to zero, and value set to nil ."

 ^ super new _initialize

]

{ #category : 'Private' }
SoftReference >> _initialize [

  inUse := false .
  useCount := 0 .
  self _setNoStubbing .

]

{ #category : 'Private' }
SoftReference >> _useCount [

 "return the useCount.  This method is provided for use in debugging only.
  The values returned are generated by the virtual machine,
  and the algorithm used to generate them may change without out notice."

  ^ useCount

]

{ #category : 'Accessing' }
SoftReference >> _value [

 " return value without incrementing useCount"
  ^ value

]

{ #category : 'Comparing' }
SoftReference >> = anObject [

" return true if the argument is a SoftReference that
  references the identical value"

^ anObject class == self class and:[ anObject _value == value ]

]

{ #category : 'Updating' }
SoftReference >> clearInUse [

  "make this SoftReference eligible to be cleared by the garbage collector."

  inUse := false

]

{ #category : 'Updating' }
SoftReference >> clearValue [

  "sets value instVar to nil.  Provided primarily for unit testing."

  value := nil

]

{ #category : 'Comparing' }
SoftReference >> hash [

"Return a positive Integer based on the identity of the value referenced by
 the receiver."

^ value identityHash


]

{ #category : 'Accessing' }
SoftReference >> inUse [

  ^ inUse

]

{ #category : 'Updating' }
SoftReference >> setInUse [

"Sets inUse to true. There is no guarantee that value will
 be non-nil after completion of this method.  After this method completes,
 this SoftReference will not be cleared by the garbage collector.
"

inUse := true

]

{ #category : 'Updating' }
SoftReference >> setValue: aValue [

  "Installs aValue as the value of the receiver.
   aValue must not be nil , use clearValue to set the value to nil .
   Returns aValue
  "
  aValue == nil ifTrue:[ ^ self error:'argument must not be nil.' ].
  value := aValue .
  self value  "increment useCount" .
  ^ aValue

]

{ #category : 'Accessing' }
SoftReference >> value [

 "if value of the receiver is not nil and not a special object,
  increments useCount. returns value of the receiver."

<primitive: 550>
self _primitiveFailed: #value

]
