Extension { #name : 'StringKeyValueDictionary' }

{ #category : 'Repository Conversion' }
StringKeyValueDictionary >> _buildWeakRefSet [

"Adds the leaf objects to the hiddenSet."

| hashKey hashValue collisionBkt weakRef |
weakRef := (GsBitmap newForHiddenSet: #WeakReferences).

1 to: tableSize do: [ :tableIndex |
  hashKey := self keyAt: tableIndex.
  hashValue := self valueAt: tableIndex.
  (hashKey == nil)
    ifTrue: [ collisionBkt := hashValue.
              (collisionBkt == nil)
                 ifFalse: [ weakRef add: collisionBkt]]
  ].
^nil

]
