Extension { #name : 'UnauthorizedObjectStub' }

{ #category : 'Private' }
UnauthorizedObjectStub >> __asString [
  self isCommitted ifTrue:[
    | str |
    str := 'an UnauthorizedObjectStub(read authorization error on oop ' copy.
    str add: self asOop asString; add: $) .
    ^ str
  ].
  ^ 'an UnauthorizedObjectStub(not committed)' copy .

]

{ #category : 'Private' }
UnauthorizedObjectStub >> _dnuError: aSymbol args: anArray reason: dnuKind [
 "dnuKind constants must agree with  DNU_ constants in om.hf .
  Not using class variables for DNU_* to avoid polluting name space of Object. "
 | err |
 err := InternalError new .
 dnuKind _isSmallInteger ifTrue:[
   dnuKind == 1 ifTrue:[
     err details: 'method needs recompile, receiver a ',
	  self class name , ' , selector #', aSymbol  ;
	   tag: { self . aSymbol }.
   ] ifFalse:[
     dnuKind == 2 ifTrue:[ err details: 'method load error DNU_failure2' ].
     dnuKind == 3 ifTrue:[ err details: 'method load error DNU_failure3' ].
     dnuKind == 4 ifTrue:[ err details: 'method is not invariant' ].
     dnuKind == 5 ifTrue:[ err details: 'method load error DNU_largeLeafMissing'].
     dnuKind == 6 ifTrue:[ err details:'method load error DNU_badExtrasSize' ].
     dnuKind == 7 ifTrue:[ err details:'method load error DNU_methodDoesNotExist' ].
     err tag:{ self . aSymbol . anArray }.
   ].
 ] ifFalse:[
   err details: 'method oop:' , dnuKind asOop asString, ' needs recompile, receiver a ',
	  self class name , ' , selector #', aSymbol  ;
	   tag: { self . aSymbol }.
 ].
 ^ err signal .

]

{ #category : 'Private' }
UnauthorizedObjectStub >> _doesNotUnderstand: aSymbol args: anArray envId: aSmallInt reason: dnuKind [
  "This private message is sent by the virtual machine. The implementation must
 be in the persistent method dictionary for Object, since the method is preloaded
 during VM startup.  Reimplementations in a session methods dictionary will not
 be seen."

  dnuKind ~~ 0 ifTrue: [
    "a more severe problem such as method needing recompile"
    self _dnuError: aSymbol args: anArray reason: dnuKind
  ].
  aSmallInt == 0 ifTrue:[
     "this path for compatibility with Gs64 v2.x, and assumes you are using
      only method environment 0  for all of your Smalltalk code."
     aSymbol == #doesNotUnderstand: ifTrue:[
       ^ Error signal:'recursive doesNotUnderstand'.
     ]. 
     ^self doesNotUnderstand: (Message selector: aSymbol arguments: anArray)
  ].
  aSymbol == #doesNotUnderstand:args:envId: ifTrue:[
    ^ Error signal:'recursive doesNotUnderstand' .
  ].
  ^self doesNotUnderstand: aSymbol args: anArray envId: aSmallInt
]

{ #category : 'Accessing' }
UnauthorizedObjectStub >> _status: checkClosureBool [

"See Object >> _status"
<primitive: 39>
self _primitiveFailed: #_status: args: { checkClosureBool } .
self _uncontinuableError

]

{ #category : 'Private' }
UnauthorizedObjectStub >> _topazAsString [
 ^ [ self __asString
   ] onSynchronous: AbstractException do:[:ex |
     '<error during asString>'
   ]

]

{ #category : 'Comparing' }
UnauthorizedObjectStub >> == anObject [

"(Optimized selector.)  Returns true if the receiver and the argument are the
 same object.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self == anObject

]

{ #category : 'Comparing' }
UnauthorizedObjectStub >> ~~ anObject [

"(Optimized selector.)  Returns true if the receiver and the argument are not
 the same object.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass. This implementation is so that perform will work."

^ self ~~ anObject

]

{ #category : 'Converting' }
UnauthorizedObjectStub >> asOop [

"Returns the value of the receiver's object-oriented pointer (OOP) as a
 positive Integer .  This is the receiver's unique identifier that
 distinguishes it from all other objects.  For non-special objects
 and for instances of 
   Boolean Character SmallDate SmallDateAndTime 
   SmallFraction SmallScaledDecimal SmallTime UndefinedObject
 the result will always be a SmallInteger.  For instances of SmallInteger
 and SmallDouble the result may be a LargeInteger.

 The result is different from the result obtained in Gemstone64 v1.x"

<primitive: 86>
self _primitiveFailed: #asOop

]

{ #category : 'Encoded OOPs' }
UnauthorizedObjectStub >> asOopNumber [

"If the receiver is a non-special object, return the receiver's
 oopNumber as defined under OOP_TAG_POM_OOP in the file
 $GEMSTONE/include/gcioop.ht  , otherwise return nil . "

| oop |
oop := self asOop .
oop _isSmallInteger ifFalse:[ ^ nil ].
(oop bitAnd:7) == 1 ifFalse:[ ^ nil ].
^ oop bitShift: -8

]

{ #category : 'Private' }
UnauthorizedObjectStub >> asString [
^ self __asString

]

{ #category : 'Comparing' }
UnauthorizedObjectStub >> basicIdentityHash [

"This method returns some Integer related to the identity of the receiver.  If
 two objects compare identically (==) to each other, the results of sending
 basicIdentityHash to each of those objects is equal."

"Faster than identityHash.  Used in GsMethodDictionary ."


<primitive: 321>

self _primitiveFailed: #basicIdentityHash .
self _uncontinuableError

]

{ #category : 'Accessing' }
UnauthorizedObjectStub >> canBeWritten [

"Returns true if the current user has write authorization for the
 receiver, false if not."

^ ((self _status: false)  bitAnd: 16r10) ~~ 0

]

{ #category : 'Private' }
UnauthorizedObjectStub >> class [
"Returns the object that is the receiver's class."
<primitive: 610 >
^ self _primitiveFailed: #class .

]

{ #category : 'Error Handling' }
UnauthorizedObjectStub >> doesNotUnderstand: aMessageDescriptor [

"The method is for compatiblity with Gs64 v2.x, and assumes you are using
   only method environment 0  for all of your Smalltalk code."

| sel str |
sel := aMessageDescriptor at: 1 .
(str := self __asString)
   add: ' does not understand ';
   add: sel _asSource .
^ SecurityError new _number: 2115"AUTH_ERR_SEG_READ" ;  signal: str .

]

{ #category : 'Comparing' }
UnauthorizedObjectStub >> identityHash [

"This method returns some Integer related to the identity of the receiver.  If
 two objects compare identically (==) to each other, the results of sending
identityHash to each of those objects will be equal."

<primitive: 609 >

self _primitiveFailed: #identityHash .
self _uncontinuableError

]

{ #category : 'Accessing' }
UnauthorizedObjectStub >> isCommitted [

"Returns true if the receiver existed in GemStone at the time the current
 transaction began.  Returns false otherwise."

^((self _status: true) bitAnd: 2) ~~ 0

]

{ #category : 'Accessing' }
UnauthorizedObjectStub >> isSpecial [
  ^ false

]

{ #category : 'Accessing' }
UnauthorizedObjectStub >> isWritten [

"Returns true if the receiver was a committed object at the start of the
 current transaction and as been written by the current transaction.
 Returns false otherwise."

^((self _status: true) bitAnd: 16rA ) == 16rA

]

{ #category : 'Private' }
UnauthorizedObjectStub >> printString [
^ self __asString

]

{ #category : 'Accessing' }
UnauthorizedObjectStub >> _value [
  "attempt to allow enumeration of values in symbolLists "
  ^ nil 
]

{ #category : 'Accessing' }
UnauthorizedObjectStub >> yourself [

"Configurable optimized selector, see GsNMethod class >> configurableOptimizedSelectors.
 This implementation is only used by #perform."

  ^ self

]
