Extension { #name : 'Utf16' }

{ #category : 'Converting' }
Utf16 class >> fromString: aString [

^ aString encodeAsUTF16

]

{ #category : 'Instance Creation' }
Utf16 class >> new: aSize [
  "aSize is number of code points"
  ^ super new: aSize * 2

]

{ #category : 'Instance Creation' }
Utf16 class >> withAll: aStringOrUtf [
  ^ aStringOrUtf encodeAsUTF16

]

{ #category : 'Accessing' }
Utf16 >> _asUnicode16 [
^ self decodeToUnicode _asUnicode16

]

{ #category : 'Accessing' }
Utf16 >> _asUnicode7 [
^ self decodeToUnicode _asUnicode7

]

{ #category : 'Accessing' }
Utf16 >> _basicAt: index put: char [
"Disallowed , build a complete Unicode7, Unicode16 or Unicode32
and then convert with encodeAsUTF16"
^ self shouldNotImplement: #at:put:

]

{ #category : 'Converting' }
Utf16 >> _coerceToUnicode [

^ self _decodeFromUtf16: true

]

{ #category : 'Private' }
Utf16 >> _decodeFromUtf16: unicodeResultBool [

"Decode UTF16 contents of the receiver.
 If unicodeResultBool == true, result is a Unicode7 , Unicode16 or Unicode32.
 If unicodeResultBool == false, result is a String, DoubleByteString or
  QuadByteString."

<primitive: 1085>
unicodeResultBool _validateClass: Boolean .
^ self _primitiveFailed: #_decodeFromUtf16: args: { unicodeResultBool }

]

{ #category : 'Private' }
Utf16 >> _decodeFromUtf8: unicodeResultBool maxSize: aSize [

^ self shouldNotImplement: #_decodeFromUtf8:maxSize:

]

{ #category : 'Accessing' }
Utf16 >> _decodeUtf8At: anOffset bytesConsumed: anArray [

"Disallowed"
^ self shouldNotImplement: #_decodeUtf8At:bytesConsumed:

]

{ #category : 'Accessing' }
Utf16 >> _decodeUtf8StartingAt: anOffset unicodeResult: unicodeResultBool
                 maxSize: aSize bytesConsumed: anArray [

"Disallowed"
^ self shouldNotImplement: #_decodeUtf8StartingAt:unicodeResult:maxSize:bytesConsumed:

]

{ #category : 'Accessing' }
Utf16 >> _deleteNoShrinkFrom: startIndex to: endIndex anchorTailSize: aSize [
"Disallowed"
^ self shouldNotImplement: #_deleteNoShrinkFrom:to:anchorTailSize:

]

{ #category : 'Accessing' }
Utf16 >> _int32LittleEndianAt: startIndex put: anInteger [

"Disallowed"
^ self shouldNotImplement: #_int32LittleEndianAt:put:

]

{ #category : 'Accessing' }
Utf16 >> _primAddRandomBytes: anIntHowMany startingAt: anIntOffset [

"Disallowed"
^ self shouldNotImplement: #_primAddRandomBytes:startingAt:

]

{ #category : 'Accessing' }
Utf16 >> _reverseDeleteNoShrinkFrom: startIndex to: endIndex anchorHeadSize: aSize [
"Disallowed"
^ self shouldNotImplement: #_reverseDeleteNoShrinkFrom:to:anchorHeadSize:

]

{ #category : 'Comparing' }
Utf16 >> < argString [
  argString _isSymbol ifTrue:[ ^ false ].
  ^ self decodeToUnicode < argString _coerceToUnicode

]

{ #category : 'Comparing' }
Utf16 >> <= argString [
  ^ (self > argString) == false

]

{ #category : 'Comparing' }
Utf16 >> = argString [
  argString _isSymbol ifTrue:[ ^ false ].
  ^ [  self decodeToUnicode = argString _coerceToUnicode
    ] on: MessageNotUnderstood do:[ :ex | ex return: false ]

]

{ #category : 'Comparing' }
Utf16 >> > argString [
  argString _isSymbol ifTrue:[ ^ false ].
  ^ self decodeToUnicode > argString _coerceToUnicode

]

{ #category : 'Comparing' }
Utf16 >> >= argString [
  ^ (self < argString ) == false

]

{ #category : 'Converting' }
Utf16 >> asByteArray [
 ^ self shouldNotImplement: #asByteArray

]

{ #category : 'Converting' }
Utf16 >> asUnicodeString [
  "Decode the receiver returning an instance of Unicode7 , Unicode16 or Unicode32."

  ^ self _decodeFromUtf16: true

]

{ #category : 'Accessing' }
Utf16 >> at: anIndex [

"Returns an Integer, a 16 bit word from the UTF16 data"
| word |
word := super at: (anIndex * 2) -1 signed: false width: 2 .
"word is bigEndian"
System gemIsBigEndian ifFalse:[ | a b |
  a := word bitShift: -8 .
  b := word bitAnd: 16rFF .
  word := (b bitShift: 8) bitOr: a
].
^ word

]

{ #category : 'Accessing' }
Utf16 >> at: index put: char [
"Disallowed , build a complete Unicode7, Unicode16 or Unicode32
and then convert with encodeAsUTF16"
^ self shouldNotImplement: #at:put:

]

{ #category : 'Accessing' }
Utf16 >> at: index put: aString fromOffset: stringOffset sizeBytes: numBytes [
"Disallowed , build a complete Unicode7, Unicode16 or Unicode32
and then convert with encodeAsUTF16"
^ self shouldNotImplement: #at:put:fromOffset:sizeBytes:

]

{ #category : 'Accessing' }
Utf16 >> at: index put: aNumber signed: aBool width: aWidthInBytes [
"Disallowed"
^ self shouldNotImplement: #at:put:signed:width:

]

{ #category : 'Accessing' }
Utf16 >> at: index putChar: char [
"Disallowed , build a complete Unicode7, Unicode16 or Unicode32
and then convert with encodeAsUTF16"
^ self shouldNotImplement: #at:putChar:

]

{ #category : 'Accessing' }
Utf16 >> at: aSmallInt putOldOopValueOfObject: anObject [
"Disallowed"
^ self shouldNotImplement: #at:putOldOopValueOfObject:

]

{ #category : 'Accessing' }
Utf16 >> at: aSmallInt putOopValueOfObject: anObject [
"Disallowed"
^ self shouldNotImplement: #at:putOopValueOfObject:

]

{ #category : 'Accessing' }
Utf16 >> at: index signed: aBool width: aWidthInBytes [
"Disallowed"
^ self shouldNotImplement: #at:signed:width:

]

{ #category : 'Accessing' }
Utf16 >> at: index sizeBytes: anInt stringSize: anIntOrNil [
"Disallowed"
^ self shouldNotImplement: #at:sizeBytes:stringSize:

]

{ #category : 'Converting' }
Utf16 >> bytesIntoString [
  ^ self shouldNotImplement: #bytesIntoString

]

{ #category : 'Converting' }
Utf16 >> bytesIntoUnicode [
 "Disallowed, use decodeToUnicode"
 ^ self shouldNotImplement: #bytesIntoUnicode

]

{ #category : 'Accessing' }
Utf16 >> charAt: index [

"Disallowed, convert with decodeToUnicode first"
^ self shouldNotImplement: #charAt:

]

{ #category : 'Accessing' }
Utf16 >> compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: numSizeBytes useCase: aBool [
"Disallowed"
^ self shouldNotImplement: #compareStringAt:to:startingAt:sizeBytes:useCase:

]

{ #category : 'Accessing' }
Utf16 >> copyFrom: startIndex to: stopIndex [

"Disallowed"
^ self shouldNotImplement: #copyFrom:to:

]

{ #category : 'Accessing' }
Utf16 >> dateTimeAt: startIndex put: aDateTime width: anInt [
"Disallowed"
^ self shouldNotImplement: #dateTimeAt:put:width:

]

{ #category : 'Accessing' }
Utf16 >> dateTimeAt: startIndex width: anInt [
"Disallowed"
^ self shouldNotImplement: #dateTimeAt:width:

]

{ #category : 'Converting' }
Utf16 >> decodeToString [
  "Decode the receiver returning an instance of String, DoubleByteString, or QuadByteString."

  ^ self _decodeFromUtf16: false

]

{ #category : 'Converting' }
Utf16 >> decodeToUnicode [
  "Decode the receiver returning an instance of Unicode7 , Unicode16 or Unicode32."

  ^ self _decodeFromUtf16: true

]

{ #category : 'Accessing' }
Utf16 >> deleteIndexKeyAt: anIndex [
"Disallowed"
^ self shouldNotImplement: #deleteIndexKeyAt:

]

{ #category : 'Accessing' }
Utf16 >> doubleByteCharAt: index [
"Disallowed, convert with decodeToUnicode first"
^ self shouldNotImplement: #doubleByteCharAt:

]

{ #category : 'Converting' }
Utf16 >> encodeAsUTF16 [
  "The receiver is already a Utf16."
  ^ self

]

{ #category : 'Converting' }
Utf16 >> encodeAsUTF8 [

^ self decodeToUnicode encodeAsUTF8

]

{ #category : 'Accessing' }
Utf16 >> getObjectWithOldOopValueAt: anOffset [
"Disallowed"
^ self shouldNotImplement: #getObjectWithOldOopValueAt:

]

{ #category : 'Accessing' }
Utf16 >> getObjectWithOopValueAt: anOffset [
"Disallowed"
^ self shouldNotImplement: #getObjectWithOopValueAt:

]

{ #category : 'Hashing' }
Utf16 >> hash [
  "inefficient, not intended for frequent use"
  ^ self decodeToUnicode hash

]

{ #category : 'Accessing' }
Utf16 >> insertAll: aByteArray at: anIndex [

anIndex == (self size + 1) ifTrue:[ ^ super insertAll: aByteArray at: anIndex].

"Insertion in the middle of a Utf16 is disallowed"
ArgumentError signal:'a Utf16 may only be created to by encoding, or appended to'

]

{ #category : 'Accessing' }
Utf16 >> int32LittleEndianAt: startIndex [

"Disallowed"
^ self shouldNotImplement: #int32LittleEndianAt

]

{ #category : 'Accessing' }
Utf16 >> quadByteCharAt: index [
"Disallowed, convert with decodeToUnicode first"
^ self shouldNotImplement: #quadByteCharAt:

]

{ #category : 'Accessing' }
Utf16 >> removeFrom: startIndex to: stopIndex [

"Disallowed"
^ self shouldNotImplement: #removeFrom:to:

]

{ #category : 'Accessing' }
Utf16 >> replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex [
"Disallowed"
^ self shouldNotImplement: #replaceFrom:to:with:startingAt:

]

{ #category : 'Accessing' }
Utf16 >> shortStringAt: anIndex compareWith: aByteObject startingAt: stringOffset opCode: anOpCode [
"Disallowed"
^ self shouldNotImplement: #shortStringAt:compareWith:startingAt:opCode

]

{ #category : 'Accessing' }
Utf16 >> size [
"Return the size in units of 16 bit words"
^ super size bitShift: -1

]

{ #category : 'Private' }
Utf16 >> unsigned16At: index put: aValue [
  "Private-for use in testing"
  ^ super at: index put: aValue signed: false width: 2

]

{ #category : 'Streams' }
Utf16 >> readStream [
  "Disallowed, you need to decode the Utf16 and then create a stream."
  ^ self shouldNotImplement: #readStream
]

{ #category : 'Accessing' }
Utf16 >> atOrNil: anIndex [
"Disallowed "
^ self shouldNotImplement: #atOrNil:

]

