Extension { #name : 'JapaneseString' }

{ #category : 'Private' }
JapaneseString class >> withBytes: aByteObject [

"Returns a new instance of the receiver that contains the bytes in the
 argument aByteObject. "

| result size |
size := aByteObject _basicSize.
((size \\ self charSize) ~= 0) ifTrue: [
  self _error: #objErrBadSize args: { size . self class }
].
result:= self new _basicSize: size.
1 to: size do: [:i | result _basicAt: i put: (aByteObject _basicAt: i) ].
^ result.

]

{ #category : 'Converting' }
JapaneseString >> asUnicodeString [

"Returns an EUCString representing the receiver."

"Must be reimplemented in EUCString to return self !!
 This implementation handles other weird kinds of multiple-byte Strings
 that the user or engineers might dream up."

| s |
s := Unicode7 new .
1 to: self size do:[:n| s addCodePoint: (self codePointAt: n) ].
^ s

]

