Extension { #name : 'GsComLitLeaf' }

{ #category : 'Instance creation' }
GsComLitLeaf class >> newNil [
  ^ self new specialLiteral: nil

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> arrayLiteral: anArray [

"anArray is a literal such as the Smalltalk literal  #( 1 2 abc )
 which can be constructed without executing any bytecodes.

 In Smalltalk , these arrays are  Invarant , and the  Parser
 canonicalizes them based on comparing substrings from the source code.
"
  self setIRnodeKind .
  "stringForm left as nil for now"
  litKind := COMPAR_ARRAY_LIT .
  litValue := anArray .
  anArray immediateInvariant

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> characterLiteral: aCharacter [
  self setIRnodeKind .
  litValue := aCharacter .
  litKind := COMPAR_CHAR_LIT .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> constRefLiteral: aRubyConstantRef [

  self setIRnodeKind .
  litKind := COMPAR_ASSOC_LIT .  "fault into old_gen if possible"
  litValue := aRubyConstantRef .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> deferredGlobalLiteral: anObject [

"used in ruby IR "

  self setIRnodeKind .
  "stringForm left as nil for now"
  litKind := COMPAR_ARRAY_LIT .
  litValue := anObject .   "do not make invariant."

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> floatLiteral: aFloat [
  litValue := aFloat .
  self setIRnodeKind .
  litKind := COMPAR_FLT_LIT .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> floatLiteralFromString: aString [

  "See Float>>fromString: for details of NaN representations in the input."

  self floatLiteral: (Float fromString: aString)

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> integerLiteral: anInteger [
  litValue := anInteger .
  self setIRnodeKind .
  litKind := COMPAR_INT_LIT

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> integerLiteralFromString: aString [
  stringForm := aString .
  self integerLiteral: (Integer fromString: aString)

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> methodLiteral: anASTnode [

"anASTnode is the root of a graph of the AST for the method,
 need to transform that tree to tree beginning with a GsComMethNode
 at the time we want to compile the method.  So the AST tree is
 sometimes persistent.
"
  self setIRnodeKind .
  "sourceForm left as nil,  method has source in its debug info."
  litValue := anASTnode .
  litKind := COMPAR_METHOD_LIT .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> objectLiteral: anObj [

"Used for generic non-Assocation non-invariant literals
 in Ruby methods."

  self setIRnodeKind .
  "stringForm left as nil for now"
  litKind := COMPAR_ARRAY_LIT .
  litValue := anObj .   "do not set invariant"

]

{ #category : 'Printing' }
GsComLitLeaf >> printFormattedOn: aStream [

  super printOn: aStream .
  aStream print:' litValue:' int: litValue ;
          print:' litKind:' int: litKind ;
      nextPut: $) ; cr .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> rubyCopyingStringLiteral: aString [

  "This literal will be accessed with a PUSH_COPYOF_LIT bytecode
   see also comments in stringLiteral: . "

  aString _isOneByteString ifFalse:[
    self error:'expected a String'   "detect parser problems, relax when QB string"
  ].
  self setIRnodeKind .
  stringForm := aString .
  litKind := COMPAR_RUBY_COPYING_STR_LIT .
  litValue := aString .
  aString immediateInvariant .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> setIRnodeKind [
  kind :=  COMPAR_LIT_LEAF

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> specialLiteral: aValue [
  "aValue is expected to be an instance of Boolean or UndefinedObject"
  self setIRnodeKind .
    litValue := aValue .
  litKind := COMPAR_SPECIAL_LIT .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> stringLiteral: aString [

" aString is a  string literal such as the Smalltalk literal  'abc'
  that can be completely generated by the Parser.

 It is the responsibility of the parser to maintain a dictionary
 of String literals if it is desired to canonicalize Strings  within
 method compilations, or across method compilations .  All String
 literals will be made invariant by the code generator."

  self setIRnodeKind .
  stringForm := aString .
  litKind := COMPAR_STR_LIT .
  litValue := aString .

  aString immediateInvariant .

]

{ #category : 'Instance Initialization' }
GsComLitLeaf >> symbolLiteral: aString [

  | sym |
  self setIRnodeKind .
  stringForm := aString .
  sym := aString asSymbol .
  sym class == DoubleByteSymbol ifTrue:[
    self error:'DoubleByteSymbol not supported for Ruby.'
  ].
  litValue :=  sym .
  litKind := COMPAR_SYM_LIT .

]

{ #category : 'Accessing' }
GsComLitLeaf >> symbolLiteralValue [
  litKind == COMPAR_SYM_LIT ifFalse:[ self error:'not a symbol leaf' ].
  ^ litValue

]
