Extension { #name : 'GsComMethNode' }

{ #category : 'Instance creation' }
GsComMethNode class >> checkRubyInfoMasks [
 "check classVars defined by bom.c against constants hardcoded in
  this class."
 | v |
 (v := (IsPrivate_mask bitOr: IsProtected_mask)) == 16r600 ifFalse:[ 
    Error signal:'inconsistent constant, v = 16r', v asHexString .
  ].
 ^ true

]

{ #category : 'Instance creation' }
GsComMethNode class >> new [

"disallowed , use newSmalltalk"
self shouldNotImplement: #new

]

{ #category : 'Instance creation' }
GsComMethNode class >> newSmalltalk [
  ^ self _basicNew initialize setSmalltalk

]

{ #category : 'Instance creation' }
GsComMethNode >> addMethodProtection: anInt [
  "used in building IR to transfer default private/protected from
   current class to this method node, if method not automatically
   private (like  initialize method)"
  | prot mask newBits iv |
  mask := 16r600 .
  iv := rubyInfo .
  prot := (iv bitAnd: mask) bitShift: -9 . "inline methodProtection"
  anInt > prot ifTrue:[
    (anInt >= 0 and:[anInt <= 2]) ifFalse:[
       ArgumentError signal:'invalid method protection argument'
    ].
    newBits := anInt bitShift: 9 .
    rubyInfo := (iv bitAnd: (mask bitInvert))  bitOr: newBits
  ].

]

{ #category : 'Instance creation' }
GsComMethNode >> appendArg: aGsComVarLeaf [
  aGsComVarLeaf varKind == COMPAR_METHOD_ARG_VAR ifFalse:[
    self error: 'bad arg kind ', aGsComVarLeaf varKindString
  ].
  arguments addLast: aGsComVarLeaf

]

{ #category : 'Instance creation' }
GsComMethNode >> appendStatement: aNode [
  aNode sourceOffset ifNil:[ | bsiz |
    (bsiz := body size) > 0 ifTrue:[
      aNode sourceOffset:( (body at: bsiz) sourceOffset).
    ]
  ].
  body addLast: aNode .
  srcOffset ifNil:[ | ofs |
    ofs := aNode sourceOffset .
    ofs ifNotNil:[ srcOffset := ofs ]
        ifNil:[ lineNumber ifNil:[ lineNumber := aNode lineNumber]].
  ].

]

{ #category : 'Instance creation' }
GsComMethNode >> appendTemp: aGsComVarLeaf [
  aGsComVarLeaf varKind == COMPAR_METHOD_TEMP_VAR  ifFalse:[
    self error: 'bad arg kind ', aGsComVarLeaf varKindString
  ].
  temps addLast: aGsComVarLeaf

]

{ #category : 'Accessing' }
GsComMethNode >> arguments [
  ^ arguments

]

{ #category : 'Instance creation' }
GsComMethNode >> class: aBehavior [
  theClass := aBehavior

]

{ #category : 'Instance creation' }
GsComMethNode >> endSourceOffset: anOffset [
  endSrcOffset := anOffset

]

{ #category : 'Instance creation' }
GsComMethNode >> envId [
  ^ rubyInfo bitAnd: Env_mask

]

{ #category : 'Instance creation' }
GsComMethNode >> environment: anInteger [
  (anInteger < 0 or:[ anInteger > 255]) ifTrue:[
     anInteger error:'out of range'
  ].
  rubyInfo := (rubyInfo bitAnd:( Env_mask bitInvert)) bitOr: anInteger

]

{ #category : 'Accessing' }
GsComMethNode >> fileName [
  ^ fileName

]

{ #category : 'Instance creation' }
GsComMethNode >> fileName: aString [
  fileName := aString

]

{ #category : 'Instance creation' }
GsComMethNode >> fileName: nameString source: srcString [
  fileName := nameString .
  source := srcString

]

{ #category : 'Printing' }
GsComMethNode >> fileNameForPrint [
  | sz res |
  fileName ifNil:[ ^ 'nil' ].
  (res := String new) add: $' .
  (sz := fileName size) > 25 ifTrue:[
    res addAll:( fileName copyFrom: sz - 25 to: sz )
  ] ifFalse:[
    res addAll: fileName .
  ] .
  res add: $' .
  ^ res

]

{ #category : 'Instance creation' }
GsComMethNode >> forceAllArgsTmpsToVc [
  "set requiresVc bits to 2 "
  methInfo := methInfo bitOr: 16r2

]

{ #category : 'Instance creation' }
GsComMethNode >> initialize [
  kind := COMPAR_METHOD_NODE .
  arguments :=  { } .
  temps :=  { } .
  body := { } .
  "nonBridgeSelector left as nil"
  rubyInfo := 0 .
  rubyOptArgsBits := 1 . "starting source offset"

]

{ #category : 'Instance creation' }
GsComMethNode >> insertFirstStatement: aNode [
  body insertAll: { aNode } at: 1 .

]

{ #category : 'Instance creation' }
GsComMethNode >> methodProtection [
  "return the ruby method protection bits,
   result  0==public,  1==protected, 2==private  "

  ^ (rubyInfo bitAnd: 16r600) bitShift: -9

]

{ #category : 'Instance creation' }
GsComMethNode >> nonBridgeSelector: aSymbol [
  nonBridgeSelector := aSymbol

]

{ #category : 'Printing' }
GsComMethNode >> printFormattedOn: aStream [
  super printOn: aStream .
  aStream nextPutAll: ' file:' ; nextPutAll: self fileNameForPrint ;
    print:' selector: ' symbol: selector ;
    nextPutAll:' theClass: ';
      nextPutAll: (theClass ~~ nil ifTrue:[ theClass name] ifFalse:['nil '])  ;
    nextPutAll:' methInfo:'; nextPutAll: '16r'; nextPutAll: methInfo asHexString ; cr ;
    nextPutAll:' rubyInfo:'; nextPutAll: '16r'; nextPutAll: rubyInfo asHexString ; cr ;
    nextPutAll:'args:' ; do: arguments ;
    nextPutAll:'temps:' ; do: temps ;
    nextPutAll:'body:' ; do: body ;
    nextPut: $) ; cr .

]

{ #category : 'Accessing' }
GsComMethNode >> selector [
  ^ selector

]

{ #category : 'Instance creation' }
GsComMethNode >> selector: aSymbol [
  "different implementation(s) in .mcz"
  (GsComSelectorLeaf reimplementationAllowed: aSymbol inEnv: self envId) ifFalse:[
      Error signal: 'reimplementation of special selector ' , aSymbol,
                ' not allowed , near line ' , lineNumber asString , ' of ' , fileName asString .
  ].
  selector := aSymbol

]

{ #category : 'Instance creation' }
GsComMethNode >> setPrimitiveNumber: anInt [
  "set IR info corresponding to    <primitive: anInt>  in the source"
  | mask newBits |
  mask := 16rFFFF0000 .
  (anInt < 0 or:[ anInt > (mask bitShift: -16)]) ifTrue:[
    ArgumentError signal:'invalid  primitive number'
  ].
  anInt > System _maxPrimitiveNumber ifTrue:[
    ArgumentError signal:'invalid  primitive number for this VM'
  ].
  newBits := anInt bitShift: 16 .
  methInfo := (methInfo bitAnd: (mask bitInvert)) bitOr: newBits .

]

{ #category : 'Instance creation' }
GsComMethNode >> setSmalltalk [
  methInfo := 16rFFFF0000 . "primNumber:=-1, protected:=0,reqVc:=0"
  rubyInfo := 0 .

]

{ #category : 'Instance creation' }
GsComMethNode >> source: aString [
  source := aString

]

{ #category : 'Instance creation' }
GsComMethNode >> startingSourceOffset: aSmallInt [
  aSmallInt _isSmallInteger ifFalse:[ aSmallInt error:'invalid arg'].
  rubyOptArgsBits := aSmallInt

]

{ #category : 'Printing' }
GsComMethNode >> summary [
  | str |
  str := String new .
  str addAll:  ' file:' ; addAll: self fileNameForPrint ;
    addAll: ' line ' ; addAll: lineNumber asString ;
    addAll: ' selector: ' ; addAll: selector  .
  ^ str

]
