Extension { #name : 'GsComVarLeaf' }

{ #category : 'Instance creation' }
GsComVarLeaf class >> new [
"create an instance registered with VM for finalization of cData"

<primitive: 674>
self _primitiveFailed: #new

]

{ #category : 'Printing' }
GsComVarLeaf class >> varKindToString: aKind [
  aKind == COMPAR_BLOCK_ARG_VAR ifTrue:[ ^ 'BLOCK_ARG'].
  aKind == COMPAR_BLOCK_TEMP_VAR ifTrue:[ ^ 'BLOCK_TEMP'].
  aKind == COMPAR__INST_VAR ifTrue:[ ^ 'INST_VAR'].
  aKind == COMPAR_LIT_VAR ifTrue:[ ^ 'LIT_VAR'].
  aKind == COMPAR_METHOD_ARG_VAR ifTrue:[ ^ 'METHOD_ARG'].
  aKind == COMPAR_METHOD_TEMP_VAR ifTrue:[ ^ 'METHOD_TEMP'].
  "aKind == COMPAR_METH_VC_GLOBAL ifTrue:[ ^ 'METH_VC_GLOBAL']. "
  aKind == COMPAR_SELF_VAR ifTrue:[ ^ 'SELF'].
  aKind == COMPAR_SUPER_VAR ifTrue:[ ^ '_SUPER'].
  "COMPAR_LIT_VAR_SPECIAL_LITERAL not legal, from dbf conversion only"
  ^ 'INVALID_VAR'

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> blockArg: argNameSymbol argNumber: oneBasedArgNum forBlock: aGsComBlockNode [
  self setIRnodeKind.
  argNameSymbol _isSymbol ifFalse:[ self error:'expected a symbol'].
  self setVarName: argNameSymbol .
  oneBasedArgNum < 1 ifTrue:[ oneBasedArgNum error:'out of range'].
  varOffset :=  oneBasedArgNum - 1 . "convert to zero based"
  varKind := COMPAR_BLOCK_ARG_VAR .
  lexLevel := aGsComBlockNode lexLevel

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> blockTemp: tempNameSymbol sourceLexLevel: aLevel [
  "code generator will delete block temps from
   the method if there are no IR references other than the definition"
  aLevel < 1 ifTrue:[ aLevel error:'out of range'].
  self setIRnodeKind.
  tempNameSymbol _isSymbol ifFalse:[ self error:'expected a symbol'].
  self setVarName: tempNameSymbol .
  varOffset := 0 . "generator will assign offsets for temps"
  varKind := COMPAR_BLOCK_TEMP_VAR .
  lexLevel := aLevel

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> initializeSelf [
  self setIRnodeKind .
  varName :=  #self .
  varOffset := 0  .
  varKind := COMPAR_SELF_VAR .
  lexLevel := 0 .

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> initializeSuper [
  self setIRnodeKind .
  varName :=  #super .
  varOffset := 0 .
  varKind := COMPAR_SUPER_VAR .
  lexLevel := 0 .

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> instanceVariable: ivNameSymbol ivOffset: oneBasedIvOfs [
  "Parser must lookup instVar names in class definitions to determine the
   oneBasedIvOfs.  Alternatively, additional behavior could be provided here to
   take an ivName and a Class and do the lookup here ..."
  self setIRnodeKind.
  self setVarName: ivNameSymbol .
  varKind := COMPAR__INST_VAR.
  oneBasedIvOfs > 0 ifTrue:[
    "instVar at known offset, convert to zero based"
    varOffset := oneBasedIvOfs - 1.
  ] ifFalse:[
    oneBasedIvOfs == -1 ifTrue:[
      varOffset := -1 "dynamic instVar"
    ] ifFalse:[
      oneBasedIvOfs error:'out of range'
    ]
  ].

]

{ #category : 'Querying' }
GsComVarLeaf >> isArg [
  ^ varKind == COMPAR_METHOD_ARG_VAR or:[ varKind == COMPAR_BLOCK_ARG_VAR]

]

{ #category : 'Querying' }
GsComVarLeaf >> isTemp [
  "return true if varKind one of
    COMPAR_METHOD_TEMP_VAR COMPAR_BLOCK_TEMP_VAR "

  ^ varKind <= COMPAR_BLOCK_TEMP_VAR

]

{ #category : 'Accessing' }
GsComVarLeaf >> lexLevel [
  ^ lexLevel

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> literalVariable: anAssociation [
  "Smalltalk style global variable, class variable, etc .
   Hopefully usable for Ruby globals ? "
  | key |
  self setIRnodeKind.
  key := anAssociation key .
  key _isSymbol ifFalse:[ key error:'bad arg kind'].
  self setVarName:  key .
  litVarAssoc := anAssociation .
  (anAssociation isKindOf: SymbolAssociation) ifFalse:[
    self error:'arg to literalVariable: is not a SymbolAssociation'
  ].
  varOffset := 0 .
  varKind := COMPAR_LIT_VAR .

]

{ #category : 'Accessing' }
GsComVarLeaf >> litVarValue [
  varKind == COMPAR_LIT_VAR ifFalse:[ self error:'not a literal variable'].
  ^ litVarAssoc _value

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> methodArg: argNameSymbol argNumber: oneBasedArgNum [
  self setIRnodeKind.
  argNameSymbol _isSymbol ifFalse:[ self error:'expected a symbol'].
  self setVarName: argNameSymbol .
  oneBasedArgNum < 1 ifTrue:[ oneBasedArgNum error:'out of range'].
  varOffset :=  oneBasedArgNum - 1 . "convert to zero based"
  varKind := COMPAR_METHOD_ARG_VAR.
  lexLevel := 0

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> methodTemp: aSymbol [
  "code generator will delete method temps from
   the method if there are no IR references other than the definition"
  self setIRnodeKind .
  self setVarName: aSymbol .
  varOffset := 0 .  "generator will assign offsets for temps"
  varKind := COMPAR_METHOD_TEMP_VAR  .
  lexLevel := 0

]

{ #category : 'Printing' }
GsComVarLeaf >> printFormattedOn: aStream [

  super printOn: aStream .
  aStream print:' varName: ' symbol: varName ;
      nextPutAll: ' varKind:' ; nextPutAll: self varKindString ;
      print: ' lexLevel:' int: lexLevel ;
      print: ' varOffset:' int: varOffset ;
      nextPut: $) ; cr .

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> setIRnodeKind [
  kind :=  COMPAR_VAR_LEAF

]

{ #category : 'Instance Initialization' }
GsComVarLeaf >> setVarName: aName [
  varName := aName .

]

{ #category : 'Accessing' }
GsComVarLeaf >> varKind [
  ^ varKind

]

{ #category : 'Printing' }
GsComVarLeaf >> varKindString [
  ^ self class varKindToString: varKind

]

{ #category : 'Accessing' }
GsComVarLeaf >> varName [
  ^ varName

]

{ #category : 'Accessing' }
GsComVarLeaf >> varOffset [
  ^ varOffset

]
