Extension { #name : 'GsCompilerIRNode' }

{ #category : 'Accessing' }
GsCompilerIRNode >> hasPosition [
  ^ srcOffset ~~ nil or:[ lineNumber ~~ nil ]

]

{ #category : 'Accessing' }
GsCompilerIRNode >> kind [
  ^ kind

]

{ #category : 'Accessing' }
GsCompilerIRNode >> lastLineNumber [
  ^ lineNumber

]

{ #category : 'Accessing' }
GsCompilerIRNode >> lastSourceOffset [
  ^ srcOffset

]

{ #category : 'Accessing' }
GsCompilerIRNode >> lineNumber [
  ^ lineNumber

]

{ #category : 'Updating' }
GsCompilerIRNode >> lineNumber: aSmallInteger [
  "to be used only after initializating the node .
   The argument is a positive one-based  line number"

  lineNumber := aSmallInteger

]

{ #category : 'Accessing' }
GsCompilerIRNode >> litVarValueOrNil [
  ^ nil

]

{ #category : 'Printing' }
GsCompilerIRNode >> printFormattedOn: aStream [
  self printOn: aStream

]

{ #category : 'Printing' }
GsCompilerIRNode >> printOn: aStream [

  aStream nextPut: $(; space;  nextPutAll: self class name ;
     nextPutAll:' objId: ' ; nextPutAll: self asOop asString .
  srcOffset ifNotNil:[
     aStream nextPutAll:' srcOfs:' ; nextPutAll: srcOffset asString ; space
   ] ifNil:[
     aStream nextPutAll:' line:' ; nextPutAll: lineNumber asString ; space
   ].

]

{ #category : 'Printing' }
GsCompilerIRNode >> printString [
  | strm |
  strm := IndentingStream newPrinting .
  self printFormattedOn: strm .
  ^ strm contents .

]

{ #category : 'Transformation' }
GsCompilerIRNode >> returnNode [

^ GsComReturnNode new return: self

]

{ #category : 'Accessing' }
GsCompilerIRNode >> sourceOffset [
  ^ srcOffset

]

{ #category : 'Updating' }
GsCompilerIRNode >> sourceOffset: aSmallInteger [
  "Argument is a 1-based character offset into the source string."
  srcOffset ifNil:[ srcOffset := aSmallInteger ]

]

{ #category : 'Accessing' }
GsCompilerIRNode >> symbolLiteralValue [

  ^ nil "caller should signal a RubyParseError"

]

{ #category : 'Updating' }
GsCompilerIRNode >> validateEnvironment: anInteger [
  "range check on an environment identifier for a method or send node"
  (anInteger < 0 or:[ anInteger > 16rFF ]) ifTrue:[
    anInteger error:'out of range' .
    ^ 0
  ].
  ^ anInteger

]

{ #category : 'Accessing' }
GsCompilerIRNode >> varLeaf [
  ^ nil

]
