Extension { #name : 'Class' }

{ #category : 'Private' }
Class >> _subclass: className
instVarNames: anArrayOfInstvarNames
format: theFormat
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
inClassHistory: aClassHistory
description: aDescription
options: optionsArray [

	"The preferred private subclass creation method.
 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant .
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogServer:  of class creation / equivalence.
"

	| cvDict result theName ivNames theHist poolDicts modifiableBool fmtArr fmt nCivs sza szb
    civNames tNow |
	self _validatePrivilege ifFalse: [^nil].
	className _isOneByteString
		ifFalse: [(className _validateClass: CharacterCollection) ifFalse: [^nil]].
	self subclassesDisallowed
		ifTrue: [^self _error: #classErrSubclassDisallowed].
	anArrayOfClassInstVars
		ifNotNil:
			[anArrayOfClassInstVars _isArray
				ifFalse: [(anArrayOfClassInstVars _validateClass: Array) ifFalse: [^nil]]].
	aDictionary
		ifNotNil: [(aDictionary _validateClass: SymbolDictionary) ifFalse: [^nil]].
	fmtArr := self _validateOptions: optionsArray withFormat: theFormat newClassName: className .
	fmt := fmtArr at: 1.
	modifiableBool := fmtArr at: 2.
	(self instancesInvariant and: [(fmt bitAnd: 16r8) == 0])
		ifTrue: [^self _error: #classErrInvariantSuperClass].
	anArrayOfInstvarNames _isArray
		ifFalse: [(anArrayOfInstvarNames _validateClass: Array) ifFalse: [^nil]].
	ivNames := {}.
	1 to: anArrayOfInstvarNames size
		do: [:j | ivNames add: (anArrayOfInstvarNames at: j)].
	nCivs := anArrayOfClassInstVars size.
	civNames := anArrayOfClassInstVars.
	nCivs ~~ 0
		ifTrue:
			[| aSet |
			civNames := Array new: nCivs.
			aSet := IdentitySet new.
			1 to: nCivs
				do:
					[:k |
					| aName |
					aName := (anArrayOfClassInstVars at: k) asSymbol.
					self class _validateNewClassInstVar: aName.
					civNames at: k put: aName.
					aSet add: aName.
					aSet size < k
						ifTrue:
							[ImproperOperation
								signal: 'array of new class instanceVariables contains a duplicate '
										, aName printString]]].

	"Gs64 v3.0 , cvDict and poolDicts maybe nil from caller,
    and will be converted to nil if caller passed an empty Array."
	cvDict := self _makeClassVarDict: anArrayOfClassVars.

	"undo the compiler's canonicalization of empty arrays (fix bug 14103) "
	poolDicts := anArrayOfPoolDicts.
	(poolDicts _isArray and: [poolDicts size == 0]) ifTrue: [poolDicts := nil].
	theName := className asSymbol.
	tNow := DateTime now.
	result := self
				_subclass: theName
				instVarNames: ivNames
				format: fmt
				classVars: cvDict
				poolDictionaries: poolDicts
				classInstanceVars: civNames.
	modifiableBool ifTrue: [result _subclasses: IdentitySet new].
	subclasses ifNotNil: [subclasses add: result].
	aDictionary ifNotNil: [aDictionary at: theName put: result].
	"leave extraDict as nil"
	result _commentOrDescription: aDescription.
	theHist := aClassHistory.
	theHist ifNil: [theHist := ClassHistory new name: className].
	theHist notEmpty
	  ifTrue: [ 
		"remove receiver from traits, but leave the trait methods installed -- preserve existing method dictionary ... as is"
		| theCurHist|
		theCurHist := theHist current.
		result category:theCurHist _classCategory.
		theCurHist traits do: [:trait | trait removeDependentOnly: theCurHist ].
		theCurHist classTraits do: [:classTrait | classTrait removeDependentOnly: theCurHist ].
		theCurHist 
			 _extraDictRemoveKey: #traits;
			 _extraDictRemoveKey: #classTraits ].
	theHist add: result.
	result classHistory: theHist.
	result timeStamp: tNow  .
	result userId: System myUserProfile userId.
	sza := self class instSize + anArrayOfClassInstVars size.
	szb := result class instSize.
	sza == szb
		ifFalse:
			[InternalError
				signal: 'prim 233: inconsistent class instance variables, superClass+args=>'
						, sza asString , '  newClass=>'
						, szb asString].
	modifiableBool ifFalse: [result immediateInvariant].
	result copyVariables.
	self _clearCachedOrganizer.
  (fmtArr at: 3) ifTrue: [ 
    "not the final oop if a reserved oop class"
    self _logServer: 'created class ' , className, ' oop ', result asOop asString  .
  ].
	^result
]
