"
A ObsoleteTimeZone represents the policy for converting Greenwich Mean Time to local
 time.

Constraints:
	secondsFromGmt: SmallInteger
	secondsForDst: SmallInteger
	timeStartDst: SmallInteger
	weekDayStartDst: Symbol
	dayStartDst: SmallInteger
	dayEndDst: SmallInteger
	yearStartDst: SmallInteger
	standardPrintString: String
	dstPrintString: String
	dstStartTimeList: IntegerKeyValueDictionary
	dstEndTimeList: IntegerKeyValueDictionary
--- instVar dayEndDst
The day of the year (SmallInteger) by which daylight savings should have
 ended. Daylight savings actually ends on the preceding weekDayStartDst
 (see above).
--- instVar dayStartDst
The day of the year (SmallInteger) by which daylight savings should have
 started. Daylight savings actually starts on the preceding weekDayStartDst
 (see above).
--- instVar dstPrintString
The string to be printed to identify the time zone when daylight savings
 program is in effect (String).
--- instVar secondsForDst
The number of seconds for daylight savings correction (SmallInteger).
 If this is zero, there is no daylight savings in the time zone represented by
 this instance of ObsoleteTimeZone.
--- instVar secondsFromGMT
The offset from Greenwich Mean Time in seconds (SmallInteger). Time zones
 east of the Greenwich meridian have positive values, those west of the
 meridian have negative values
--- instVar standardPrintString
The string to be printed to identify the time zone when daylight savings
 program is not in effect (String).
--- instVar timeStartDst
The number of seconds after midnight when daylight savings starts
 (SmallInteger).
--- instVar weekDayStartDst
The day of the week when daylight savings time starts (Symbol). Usually
 #Sunday.
--- instVar yearStartDst
The year in which daylight savings policy came into effect (SmallInteger).
"
Class {
	#name : 'ObsoleteTimeZone',
	#superclass : 'Object',
	#instVars : [
		'secondsFromGmt',
		'secondsForDst',
		'timeStartDst',
		'weekDayStartDst',
		'dayStartDst',
		'dayEndDst',
		'yearStartDst',
		'standardPrintString',
		'dstPrintString',
		'dstStartTimeList',
		'dstEndTimeList'
	],
	#classVars : [
		'Default',
		'TimeZones'
	],
	#gs_reservedoop : '118529',
	#category : nil
}
