"

 Behavior is an abstract superclass with the concrete subclasses
 ObsoleteMetaclass and Module .
 You may not create any other subclasses of Behavior.

 Behavior describes the protocol common to all kinds of Module
 and instances of ObsoleteMetaclass.  In other words, you can send the messages listed
 here to any Class or metaclass.  In the method descriptions below,
 ""superclass"" refers to the superclass of instances of the receiver,
 not to the superclass of the receiver itself.

 instVars:
  superclass - The Behavior's immediate superclass in the
		Smalltalk environment 0  class hierarchy

  format - A SmallInteger that encodes the following information in its bits:
      (format bitAnd: 3) = 0 if instances of the Behavior are pointer objects.
      (format bitAnd: 3) = 1 if instances of the Behavior are byte objects.
      (format bitAnd: 3) = 2 if instances of the Behavior are non-sequenceable
                collections (NSCs, such as Bags and Sets).
      (format bitAnd: 3) = 3 if instances of the Behavior are special objects.

      and single bit fields per the following masks:
        16r4  instances of the Behavior have varying instVars addressable by
		a SmallInteger offset, (such as Array, String)
              previously documented as ""have indexable instVars""
        16r8  instances of the Behavior are invariant.
        16r10  the Behavior had constraints upon what can be
      	        stored in its instance variables (bit longer used)
        16r20  the Behavior does not allow subclass creation.
	16r40  Nsc duplicates allowed (1 for IdentityBag, 0 for IdentitySet)
        16r80  the Behavior does not allow structural access from GCI C interface
	16r100  obsolete bit
        16r200  no stores to instvars via structural access from GCI
        16r400  GCI traversal result via send of aClampSpecification.traversalCallBackSelector
        16r800  non-persistent bit, instances of the class may not be committed
        16r1000  dbTransient bit, instVar in instances of the class are always nil on disk.
        16r2000  self can be special , used by compiler and native code generator ,
		 set if instances of receiver or any subclass can be special objects,
                 absense of bit enables some self.class optimizations in code generator.
        16r4000  Ruby virtual class bit
        16r8000  Ruby singleton class bit
       16r10000  Ruby module-include-self bit
       16r20000  Ruby module-functions bit
      16r1000000 is a Metaclass3 
    16r180000000  byte swizzle kind bits (word size in a byte format object).
      C definitions for the bits are in $GEMSTONE/include/gcioc.ht

  instVarsInfo - A non-negative SmallInteger encoding the number of instance variables in
     instances of this class (including those inherited from superclasses)
     and additional information.   The additional information is regenerated each
     time the class is loaded into memory and is used only within the Virtual Machine.
     The mask to extract the number of instance variables is 16rFFF .
     Each instance of Behavior is limited to 2030 named instance variables.

  instVarNames - An invariant Array of Symbols giving the names of the Behavior's
     instance variables, including those inherited from superclasses.  Each instance
     variable name is limited to 64 Characters, and must begin with an
     alphabetic character or an underscore (""_"").  For more information, see
     the GemStone Programming Guide.

  constraints - An invariant Array of Classes, which may be present in classes
    created in GemStone prior to v3.4.
    Each element in the Array is the class kind of a corresponding instance
    variable defined in a class or inherited from a superclass.
    If constraints size is one larger than the size of instVarNames, the last element
    is the constraint on varying instVars.
    As of GemStone 64bit v3.4, constraints are no longer enforced.

  classVars - A SymbolDictionary used when compiling methods in this Behavior.  Each instance
     of a class has its own instance variables, which may differ in value.  Each
     class has its own class variables, which have the same value for all instances
     of the class.  For each SymbolAssociation in this dictionary, the key is a
     Symbol representing a class variable, and the corresponding value is the value
     of that class variable.  Each class variable name is limited to 64 Characters,
     and must begin with an alphabetic character or an underscore (""_"").
     When resolving variable names, method compilation searches the classVars of
     the class in which a method is being compiled, and also the classVars of superclasses.

  methDicts -  A GsMethodDictionary that has all of the additional protocol
	(not inherited from superclasses) for instances of this Behavior.
    May also be an Array .
    If an Array, the array holds groups of 4 ,
        methodDict for envId is      methDicts at:(envId*4 + 1)
        rubyNameSpace for envId is   methDicts at:(envId*4 + 2)
        superclass for envId is      methDicts at:(envId*4 + 3)

      Examples
        methodDict for env 1  is     methDicts at: 5  (or _rubyAt:4)
        rubyNameSpace for env 1 is   methDicts at: 6  (or _rubyAt:5)
        superclass for env 1  is     methDicts at: 7  (or _rubyAt:6)

      Note image and primitives code for following the superClass
      link for envId == 0  always uses   self superClass ,i.e. the
      superClass instVar not   (methDicts at: 3)

      See also class comment for Module for transientMethDicts instVar.

  poolDictionaries -  An Array of SymbolDictionaries used when compiling methods in
     this Behavior.  The dictionaries contain objects that can be shared by multiple classes
     and multiple users.  When resolving variable names, method compilation searches
     the poolDictionaries of the class in which a method is being compiled, but
     does not search poolDictionaries of superclasses.

  categorys - A GsMethodDictionary that categorizes selectors in this Behavior.
     For each element in this dictionary, the key is a method category Symbol, and the
     corresponding value is a SymbolSet of the selectors for that method category.
     May also be an Array of GsMethodDictionarys if class contains
     methods with environmentId > 0.
     Support for categories for environmentId > 0 is mostly not implemented.

  dbTransientMask - nil or a SmallInteger whose bits specify dbTransient instance variables.

Constraints:
	superClass: Behavior
	format: SmallInteger
	instVarsInfo: SmallInteger
	instVarNames: Array
	constraints: Object
	classVars: SymbolDictionary
	methDicts: Object
	poolDictionaries: Array
	categorys: Object
	dbTransientMask: SmallInteger

"
Class {
	#name : 'Behavior',
	#superclass : 'Object',
	#instVars : [
		'superClass',
		'format',
		'instVarsInfo',
		'instVarNames',
		'constraints',
		'classVars',
		'methDicts',
		'poolDictionaries',
		'categorys',
		'dbTransientMask'
	],
	#classVars : [
		'Class_numIvs_mask',
		'GC_NON_PERSISTENT_MASK',
		'GC_RubyModuleNP',
		'METH_lu_skipPersistentMd',
		'METH_lu_undef_ed',
		'METH_prot_override_private',
		'METH_prot_override_protected',
		'METH_prot_override_public',
		'METH_prot_private',
		'METH_prot_protected',
		'METH_prot_public'
	],
	#gs_options : [
		'subclassesDisallowed'
	],
	#gs_reservedoop : '67585',
	#category : nil
}

{ #category : 'Updating the Method Dictionary' }
Behavior >> compileMethod: sourceString category: aCategoryString environmentId: environmentId [
  ^ self compileMethod: sourceString 
     dictionaries: GsSession currentSession symbolList
     category: aCategoryString environmentId: environmentId
]

{ #category : 'Updating the Method Dictionary' }
Behavior >> compileMethod: sourceString dictionaries: aSymbolList category: aCategoryString environmentId: environmentId [
	"This compiles some source code for the receiver.  The first argument,
 sourceString, is the string of source code to be compiled.  The second
 argument is a SymbolList to be used in parsing, along with the list of all
 class variables and pool dictionaries for the receiver and all of its
 superclasses.  The third argument (a String) indicates the method's category.

 sourceString must be a kind of String or DoubleByteString.  Instances of
 JapaneseString are not supported as source strings.  String literals
 ('abc') are generated as instances of the class of sourceString,
 unless sourceString is a Symbol, in which case 'abc' produces a String.
 If sourceString is a DoubleByteSymbol, 'abc' produces a DoubleByteString.

 anEnvironmentId must be a SmallInteger >= 0 and <= 16rFFFF.
 0 denotes the base Smalltalk image.  1 was reserved for use by Ruby .

 If there are no errors, this adds the resulting compiled method to the
 receiver's method dictionary and returns that method,
 otherwise signals a CompileError .
 A CompileWarning may be signaled, after adding the new method
 to a receiver's method dictionary."

	| symList categ dictsArray mDict cDict meth policy |
	self _validatePrivilege
		ifFalse: [ ^ nil ].

	aSymbolList class == SymbolList
		ifTrue: [ symList := aSymbolList ]
		ifFalse: [ 
			aSymbolList _validateClass: Array.
			symList := SymbolList withAll: aSymbolList ].
	categ := aCategoryString asSymbol.
	dictsArray := (policy := GsPackagePolicy current)
		methodAndCategoryDictionaryFor: self
		source: sourceString
		dictionaries: aSymbolList
		category: categ.
	mDict := dictsArray at: 1.
	cDict := dictsArray at: 2.
	mDict
		ifNotNil: [ 
			meth := self
				compileMethod: sourceString
				dictionaries: symList
				category: categ
				intoMethodDict: mDict
				intoCategories: cDict
				environmentId: environmentId.
			policy updateMethodLookupCacheFor: meth in: self.
			environmentId == 0
				ifTrue: [ policy setStamp: self changeStamp forBehavior: self forMethod: meth selector ].
			^ meth ]
		ifNil: [ 
			^ self
				_rwCompileMethodForConditionalPackaging: sourceString
				symbolList: symList
				category: categ
				environmentId: environmentId
				ifUnpackagedDo: [ 
					GsObjectSecurityPolicy
						setCurrent: self objectSecurityPolicy
						while: [ 
							meth := self
								compileMethod: sourceString
								dictionaries: symList
								category: categ
								intoMethodDict: nil
								intoCategories: nil
								environmentId: environmentId.
							(environmentId == 0 and: [ policy enabled ])
								ifTrue: [ policy setStamp: self changeStamp forBehavior: self forMethod: meth selector ].
							^ meth ] ] ]
]

{ #category : 'Updating the Method Dictionary' }
Behavior >> removeAllMethods: envId [

"Removes all methods from the receiver.  This should not be done without
 considerable forethought!"
| baseCats baseMeths |
self _validatePrivilege ifFalse:[ ^ nil ].
baseCats := self _baseCategorys: envId .
baseMeths := self persistentMethodDictForEnv: envId .

baseMeths ifNotNil: [
  self _rwRemoveAllMethods: baseMeths environmentId: envId.
  baseMeths removeAll .
  baseMeths valueConstraint: GsNMethod . "to handle v2.3 to v3.0 image upgrade"
].
baseCats ifNotNil: [ baseCats removeAll ].
envId == 0 ifTrue:[
  GsPackagePolicy currentOrNil ifNotNil:[:pp| pp removeAllMethodsFor: self].
].
self _clearLookupCaches: envId .
]
