"
CFunction is an abstract class representing the type signature of a C function.
Concrete subclasses are CCallout, CCalloutStructs, CCallin .

  instVars
     fName  , a String, the name of a callout function to be passed to dlsym() ,
          or the name of a callin function type.

     argTypes, an Array of zero or more Symbols describing the arguments .
        When native code generation is enabled by the gem config file,
          Functions using varArgs are limited to a maximum of
          20 variable arguments after the fixed arguments.
        When native code generation is disabled by the gem config file,
          Arguments and results of C type   float    are not supported.
          Functions which have one or more args of C type   double
          or whose result type is   double,
          are limited to a maximum of 4 fixed arguments.
          Functions using varArgs are limited to 4 fixed args and 10 total args.
          Otherwise functions are limited to 15 total arguments.
        See CCallout class >> library:name:result:args:  for more details .
        See comments in CCallout and CCalloutStructs for discussion of struct results and arguments.
        See comments in CCallout>>callWith: for details on varArgs .

     argTypesDict , if variable arguments supported by this function,
        references the class variable ArgTypesDict , otherwise nil.

     resultType, a Symbols describing the result of the C function.
       See method library:name:result:args:  for more details .

     cTypes , an Array for internal use
         translated representation of argTypes and resultType ,
         used by CCallout>>callWith:* primitives .

     argCounts , a SmallInteger generated from argTypes.

Constraints:
	fName: String
	argTypes: Array
	resultType: Symbol
	cTypes: ByteArray
	argCounts: SmallInteger
	argTypesDict: GsMethodDictionary

"
Class {
	#name : 'CFunction',
	#superclass : 'Object',
	#instVars : [
		'fName',
		'argTypes',
		'resultType',
		'cTypes',
		'argCounts',
		'argTypesDict'
	],
	#classVars : [
		'ArgCounts_fixedMask',
		'ArgCounts_varArgsMask',
		'ArgTypesDict',
		'CFunc_Arg_U64',
		'CFUNC_max_params',
		'CFunc_Res_U64',
		'ResTypesDict'
	],
	#gs_options : [
		'disallowGciStore'
	],
	#gs_reservedoop : '133889',
	#category : nil
}
