"
An intances of CLibrary represents a shared library.

   instVars
      name  , a String, the name of the library .
      expandedName, a String,  name after expansion of environment variables
         and symbolic links , and adding .so or other suffix,
         as was passed to dlopen(). nil in a committed instance.
         The instVar is a cache to be accessed by the primitives only.

      lastError , a String, value from dlerror() after a failure of dlopen(),
               always nil in a committed instance .
      loadAttempted,  nil in a committed instance, true if load attempted
      onLoadBlock , nil, or an ExecBlock to be run each time the
          shared library is successfully loaded; was used by Ruby.

   cData (hidden instVar) , in an in-memory instance is a handle
       returned from a successful dlopen() , or nil if library is not loaded.
   If available, the RTLD_FIRST(Solaris, Mac) flag
   is specified when calling dlopen().

   Loading of shared libraries via CLibrary is disallowed if the session''s
   UserProfile has the NoUserAction inverse privilege set .

Constraints:
	name: String
	expandedName: String
	lastError: String
	loadAttempted: Boolean
	onLoadBlock: ExecBlock

"
Class {
	#name : 'CLibrary',
	#superclass : 'Object',
	#instVars : [
		'name',
		'expandedName',
		'lastError',
		'loadAttempted',
		'onLoadBlock'
	],
	#gs_reservedoop : '133633',
	#category : nil
}
