"
A ClusterBucketArray is an Array whose elements are instances of ClusterBucket.

 There is one instance of ClusterBucketArray in a fresh GemStone repository.  It
 can be accessed via the Globals dictionary using the following GemStone
 Smalltalk statement:

 Globals at: #AllClusterBuckets.

 GemStone uses AllClusterBuckets to translate clusterIds to cluster bucket
 objects:

 classmethod: ClusterBucket
 bucketWithId: aSmallPositiveInt
   ^ AllClusterBuckets at: aSmallPositiveInt
 %

 AllClusterBuckets has a reserved object identifier, to facilitate efficient
 access of the Array from within the object manager.  Therefore, a special C
 constant, OOP_ALL_CLUSTER_BUCKETS, is defined in the gcioop.ht header file to
 permit access to it from C.

Constraints:
	[elements]: ClusterBucket
"
Class {
	#name : 'ClusterBucketArray',
	#superclass : 'Array',
	#gs_reservedoop : '82433',
	#category : nil
}
