"
An instance of Date describes a date after December 31, 1900.

 You can convert a Date to a String (using Formatting instance methods), and
 you can convert a String to a Date (using Instance Creation class methods).
 Such conversions require a specification to describe the format of the String.
 Some methods provide for the default format, DD/MM/YYYY, which expresses the
 day and month (in that order) as digits.

 Explicit string-formatting specifications take the form of an Array, described
 in the following table.  A specification is incorrect if it is missing an
 element or if an element value is not one of the acceptable values listed in
 the table.

 String-formatting Specification Array for Date.

 Element   Acceptable Value       Explanation

 1st,      Integers 1, 2,         Determines the position of the day (1),
 2nd, and  and 3, in any          month (2), and year (3).
 3rd       order

 4th       A Character literal    Separates year, month, and day.
           (such as a space, $ )

 5th       Integer                Determines the month format to be a number (1),
                                  three-letter abbreviation (2), or the entire
                                  name (3).

 6th       Integer                Determines the year format to be the entire
                                  number (1), or only the last two digits (2).

Constraints:
	year: SmallInteger
	dayOfYear: SmallInteger

instvar year -- A SmallInteger that represents the year. Years beyond 2147483647 are not
 allowed.

instvar dayOfYear -- A SmallInteger between 1 and 366 inclusive that represents the day
 of the year.

classVar WeekDayNames -- A LanguageDictionary.  Each key is a Symbol representing the native
 language, and each value is an Array of Strings, the names of the days of the week.

classVar MonthNames -- A LanguageDictionary.  Each key is a Symbol representing the native
 language, and each value is an Array of Strings, the names of the months of the year.

"
Class {
	#name : 'Date',
	#superclass : 'Magnitude',
	#instVars : [
		'year',
		'dayOfYear'
	],
	#classVars : [
		'MonthNames',
		'WeekDayNames'
	],
	#gs_options : [
		'selfCanBeSpecial'
	],
	#gs_reservedoop : '100609',
	#category : nil
}
