"
An instance of DateTime describes a moment in time (with millisecond resolution)
 on a date after December 31, 1900. All instances of DateTime are invariant.

 The internal representation of a DateTime is based on Greenwich Mean Time.
 However, many methods express time in the local time zone.  (""Local"" time is
 local to your Gem process.)  These methods automatically convert between
 time zones, but the internal representation remains in Greenwich Mean Time.
 Hence, you can interact with DateTime methods in a natural way, but DateTime
 objects can be safely compared to each other no matter what time zone is used
 to express them.

 You can convert a DateTime to a String (using Formatting instance methods), and
 you can convert a String to a DateTime (using Instance Creation class methods).
 Such conversions require a specification to describe the format of the String.
 Some methods provide for the default format, DD/MM/YYYY HH:MM:SS, which
 expresses the day and month (in that order) as digits and uses a 24-hour clock.

 Explicit string-formatting specifications take the form of an Array, described
 in the following table.  A specification is incorrect if it is missing an
 element or if an element value is not one of the acceptable values listed in
 the table.

 String-formatting Specification Array for DateTime.

 Element   Acceptable Value       Explanation

 1st,      Integers 1, 2,         Determines the position of the day (1),
 2nd, and  and 3, in any          month (2), and year (3).
 3rd       order

 4th       A Character literal    Separates year, month, and day.
           (such as a space, $ )

 5th       Integer                Determines the month format to be a number (1),
                                  three-letter abbreviation (2), or the entire
                                  name (3).

 6th       Integer                Determines the year format to be the entire
                                  number (1), or only the last two digits (2).

 7th       A Character literal    Separates hours, minutes, and seconds.
           (such as $: or $.)

 8th       true                   Include the time of day.

 8th       false                  Do not include the time of day.  Ignore elements
                                  7, 9, and 10.  Elements 9 and 10 are optional
                                  in the specification.

 9th       true                   Include seconds.

 9th       false                  Do not include seconds.

 10th      true                   Time is expressed in 12-hour format, with
                                  am or pm (such as 1:30:55 pm).  The space is
                                  required preceding the am or pm indicator.

 10th      false                  Time is expressed in 24-hour format
                                  (such as 13:30:55).

 11th      true                   Include the time zone information.

 12th      true                   Use the time zone information of the time zone
			          in which the DateTime was created rather than
                                  the local time zone.

Instance Variables

dayOfYear - A SmallInteger between 1 and 366 inclusive that represents the
  day of the year.
milliseconds - A SmallInteger that represents the number of milliseconds since
  midnight, Greenwich Mean Time.
timeZone -  The time zone in which the DateTime was created.
year -  A SmallInteger that represents the year. Must be in the range 1...1000000.

Class variables

MonthNames - A SymbolDictionary.  Each key is a Symbol representing one of the
  native languages supported by GemStone, and each value is an Array of Strings,
  the names of the months of the year in the corresponding language.

WeekDayNames - A SymbolDictionary.  Each key is a Symbol representing one of
 the native languages supported by GemStone, and each value is an Array of
 Strings, the names of the days of the week in the corresponding language.

"
Class {
	#name : 'DateTime',
	#superclass : 'Magnitude',
	#instVars : [
		'year',
		'dayOfYear',
		'milliseconds',
		'timeZone'
	],
	#classVars : [
		'MonthNames',
		'WeekDayNames'
	],
	#gs_reservedoop : '118785',
	#category : nil
}
