"
ExecBlock is the block class representing all kinds
 of executable blocks in the Gemstone64 virtual machine.
 ExecBlock was introduced in Gemstone64 version 3.0 .
 Instances of subclasses ExecBlock0..ExecBlockN exist in-memory
 only for use by the VM. In-memory copies of ExecBlocks have
 their class changed to one of ExecBlock0..ExecBlockN  after
 validating number of args, etc.  The varying instVars , if any,
 contain copies of the values of outer block(s) args or temps.

--- instVar _method
The instance of GsNMethod containing the code for this ExecBlock.
 In an in-memory ExecBlock, this instVar can contain a reference to
 a GsNativeCode object.

--- instVar iFields1
A SmallInteger which encodes the unsigned ints
    nArgs          mask             16rFF,
    lastRubyArgIsStar  mask        16r100
    rubyNoArgsDecl    mask         16r200
    nTemps mask                16rFFFF000,
    selfOffsetInVC  mask   16rFFFF0000000    (offset is zero-based)
    cost           mask  16r0300000000000
    isCopyingBlock mask  16r0400000000000
    spare                16r0800000000000
    selfOffsetInSelf    16r0F000000000000
    spare              16rFF0000000000000
    isRubyLambda mask 16r1000000000000000  (the sign bit)

--- instVar staticLink
Set to nil by the method compiler; for use by the VirtualMachine only.
 If non-nil in a stored or active block ,
 a reference to the VariableContext of the home method.

-- instVar stkSerialNum
Set to nil by the method compiler; for use by the VirtualMachine only,
 in the implementation of continuations.

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin
"
Class {
	#name : 'ExecBlock',
	#superclass : 'BlockClosure',
	#type : 'variable',
	#instVars : [
		'_method',
		'iFields1',
		'staticLink',
		'stkSerialNum',
		'ccallin'
	],
	#classVars : [
		'_rubyFrameLocalsNil'
	],
	#gs_reservedoop : '143361',
	#category : nil
}
