"

FloatingPointError is signaled for various error conditions during
numerical operations.  By default floating point operations are silent
and return a NaN or Infinity in some cases.

After
  FloatingPointError enableExceptions: #divideByZero
a floating point divide by zero will signal an instance of FloatingPointError.
Note that a divide by integer zero will always signal an instance of ZeroDivide.

FloatingPointError enableAllExceptions
will cause a FloatingPointError to be signaled whenever a floating point
arithmetic operation would produce a NaN an Infinity as the result.

See documentation in FloatingPointError class >> enabledExceptions
for the list of floating point exception conditions which can
signal a FloatingPointError .

Some operations that do not involve floating point numbers can
signal a FloatingPointError, such as LargeInteger overflow.
For example, evaluate the following expression:
	[10 raisedTo: 100000] on: FloatingPointError do: [:ex | ex halt].
Since there is no appropriate exceptional number to return, these exceptions
are not managed by exception enabling and are always signaled.

"
Class {
	#name : 'FloatingPointError',
	#superclass : 'OutOfRange',
	#classVars : [
		'divideByZero',
		'inexactResult',
		'invalidOperation',
		'overflow',
		'underflow'
	],
	#gs_reservedoop : '140289',
	#category : nil
}
