"
GsFile provides the means for creating and accessing files. These
 files reside in the file system on either the machine that is running the
 current session's Gem process (the server machine) or the machine that is
 running the client application (the client machine).  The files may be of any
 type, textual or binary, though separate protocol is provided for reading and
 writing these types of data.  File contents are in bytes and writing kinds of
 String that require multiple bytes per code pint, the contents must be
 explicitly encoded before write, or written using nextPutAllUtf8:.

 Beginning with Gs64 v3.0,  instances of GsFile automatically have
 their C state closed when the instance is garbage collected or
 when a persistent instance drops out of memory.

                              Warning:
    Do not retain an instance of GsFile from one session to another.
    Instances of GsFile are intended to exist only within a given GemStone
    session.  GsFiles that are used across sessions always generate an error.

  Path arguments specifying a directory or file to open or create
  will be converted to Utf8 if they contain code points above 255 ,
  or are implemented as a MultiByteString . On Windows clients, for
  compatibility with the OS operations, arguments are converted to Utf16.

  Access to files on the client machine are not supported if this session
  was created by an instance of GsTsExternalSession(or libgcits) in another machine.
  Sessions whose client is the libgcits have privilege NoGsFileOnClient always true.

Instance variables:

fileDescriptor -- SmallInteger

lineNumber -- SmallInteger

isClient -- a Boolean or SmallInteger,  with following stats and values
   committed pre-v2.1 instance   true or false
   temp , open                   true or false
   temp , closed                 0 or 1
   temp , closed, access error   2 or 3
   committed v2.1              any of   true/false, 0/1, 2/3

pathName -- A String that gives an absolute path name to the file.

mode -- A String that gives the file open mode for the file, as defined for the
 C-language open function.

"
Class {
	#name : 'GsFile',
	#superclass : 'IO',
	#instVars : [
		'isClient',
		'pathName',
		'mode'
	],
	#gs_reservedoop : '135169',
	#category : nil
}
