"
Each Repository is composed of an integral number of ObjectSecurityPolicies.
 A GsObjectSecurityPolicy has the following properties:

 * Ownership.  This is the smallest unit of ownership for accounting and
   authorization purposes.  Each GsObjectSecurityPolicy is owned by one and
   only one user.

 * Authorization unit.  A user may control access to objects by placing them in
   a GsObjectSecurityPolicy with a known authorization.  Prior to reading or
   writing an object in a GsObjectSecurityPolicy, users must be authorized to
   perform the desired action.
   However, during a transaction, once a user is authorized to read one object
   in a GsObjectSecurityPolicy, that user can read any object in the same
   GsObjectSecurityPolicy.

 ObjectSecurityPolicies and Repositories are discussed in more detail in the
 GemStone Programming Guide.

  All objects have a objectSecurityPolicyId attribute, which is stored in the
  object header.
  References from an object to its GsObjectSecurityPolicy are indirect via the
  SystemRepository object.
  (See implementation of method Object >> objectSecurityPolicy )
  In a Repository that was converted from Gs64 v1.x , v2.0 or v2.1 ,
  all objects created prior to conversion will have objectSecurityPolicyId 0 .

  Read authorization is checked when an object is faulted or refreshed
  into memory , once in memory no further read authorization checks
  are performed. No checks are done for an object with objectSecurityPolicyId 0.

  Write authorization is checked the first time an object is written
  during each transaction.  No checks are done for an object
  with objectSecurityPolicyId 0 .

  Changes to GsObjectSecurityPolicy, UserProfile , or Group objects that affect
  read or write authorization checks are only guaranteed to be noticed
  after the next login.  This is different from Gemston/S 6.x , in which
  authorization changes are supposed to be noticed at the
  next transaction boundary.  Changes to the objectSecurityPolicyId of an
  object will take effect on the next transaction boundary.

  Creation of ObjectSecurityPolicies and changes to attributes of
  ObjectSecurityPolicies require write authorization permission to the
  DataCuratorObjectSecurityPolicy .

  If you are logged in as SystemUser , no authorization errors will occur .

  All instances of Symbol, DoubleByteSymbol must be in a objectSecurityPolicy
  with World read permission. By default they are on
  DataCuratorObjectSecurityPolicy .

  For logins other than SystemUser, the virtual machine requires read access
  to both DataCuratorObjectSecurityPolicy and SystemObjectSecurityPolicy
  in order to be able to bootstrap object memory
  as part of a session login.  Specifically , well known classes
  such as Class, Object, etc are expected to be in SystemObjectSecurityPolicy ,
  and instances of Symbol and objects such as SystemRepository are
  expected to be in DataCuratorObjectSecurityPolicy.
  To avoid infinite recursion in loading the authorization cache,
  the virtual machine preloads authorization for SystemObjectSecurityPolicy
  and DataCuratorObjectSecurityPolicy after validating the userId/password,
  and will generate a fatal error if it does not have read access to both
  DataCuratorObjectSecurityPolicy and DataCuratorObjectSecurityPolicy.

  All instances of UserProfile,  IdentitySets representing Groups,
  and ObjectSecurityPolicies must be in a objectSecurityPolicy with World
  read permission.  By default they are on DataCuratorObjectSecurityPolicy.

  During repository conversion from a prior release to Gs64 v2.2 ,
  if the previous size of SystemRepository was < 20 , and
  a  GsObjectSecurityPolicy will be created with objectSecurityPolicyId 20
  and world write, to handle the case where an older version of GBS clients
  may have created objects in a Gs64 v2.0 or v2.1 repository
  with objectSecurityPolicyId 20 .

Instance Variables:

itsRepository -- The Repository containing the GsObjectSecurityPolicy.

itsOwner -- A UserProfile indicating the owner of the GsObjectSecurityPolicy.

groupsRead -- An IdentitySet of UserProfileGroup objects.  Each group object
 must be an element of AllGroups, and represents a group of users who are
 authorized to access the GsObjectSecurityPolicy for reading.

groupsWrite -- An IdentitySet of UserProfileGroup objects.  Each group object
 must be an element of AllGroups, and represents a group of users who are
 authorized to access the GsObjectSecurityPolicy for writing.

ownerAuthorization -- A SmallInteger specifying authorization for the owner to access the GsObjectSecurityPolicy.
 0 = no access, 1 = read access, 2 = write access.

worldAuthorization -- A SmallInteger specifying world authorization to access the GsObjectSecurityPolicy.
 0 = no access, 1 = read access, 2 = write access.

objectSecurityPolicyId -- A SmallInteger > 0,
 the offset of this GsObjectSecurityPolicy in the object SystemRepository.

trackReads - A Boolean specifying whether reads of objects in this GsObjectSecurityPolicy
 are logged.  A value of nil is equivalent to false .
 Read tracking occurs when an object is faulted into temporary object memory of a session.
 See also DisableObjectReadLogging privilege in UserProfile,
 System class >> setObjectReadTracking: , System class >> objectReadTrackingEnabled, 
 Object >> trackRead, and stone config item STN_OBJECT_READ_LOG_DIRECTORIES.

Dynamic instanceVariables
  #name    -- nil or a String .  This is for application convenience and
   is not a key in any system maintained dictionary .

"
Class {
	#name : 'GsObjectSecurityPolicy',
	#superclass : 'Object',
	#instVars : [
		'itsRepository',
		'itsOwner',
		'groupsRead',
		'groupsWrite',
		'ownerAuthorization',
		'worldAuthorization',
		'itsId',
    'trackReads'
	],
	#classVars : [
		'AuthorizationFactors',
		'AuthorizationMasks',
		'AuthorizationSymbols'
	],
	#gs_options : [
		'disallowGciStore',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '73217',
	#category : nil
}
