"
A GsSession represents a user session on the GemStone server where the
 instance exists.  It is a transient object that is useful only as long
 as the user remains logged in to GemStone.

 A GsSession can access the UserProfile of the user who is logged in to
 GemStone, can provide some minimal control over session execution, and
 can send and receive signals with other sessions.

 The current session is represented by a GsCurrentSession, a special
 subclass of GsSession.  Instances of GsSession typically represent
 other concurrent GemStone sessions in the same server.

Constraints:
	sessionSerialNum: SmallInteger
	userProfile: UserProfile

instVar sessionSerialNum -- A SmallInteger that identifies the session uniquely within the GemStone
 server.

instVar userProfile -- The UserProfile of the user who is logged in to the session.
"
Class {
	#name : 'GsSession',
	#superclass : 'AbstractSession',
	#instVars : [
		'sessionSerialNum',
		'userProfile'
	],
	#gs_reservedoop : '103681',
	#category : nil
}
